/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class FailoverSecurityRealm
implements SecurityRealm {
    protected final SecurityRealm delegateRealm;
    protected final SecurityRealm failoverRealm;
    protected final Consumer<RealmUnavailableException> failoverCallback;

    public FailoverSecurityRealm(SecurityRealm delegateRealm, SecurityRealm failoverRealm, Consumer<RealmUnavailableException> failoverCallback) {
        Assert.checkNotNullParam((String)"delegateRealm", (Object)delegateRealm);
        Assert.checkNotNullParam((String)"failoverRealm", (Object)failoverRealm);
        this.delegateRealm = delegateRealm;
        this.failoverRealm = failoverRealm;
        this.failoverCallback = failoverCallback;
    }

    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        try {
            return this.createFailoverIdentity(this.delegateRealm.getRealmIdentity(evidence), evidence);
        }
        catch (RealmUnavailableException e) {
            ElytronMessages.log.realmFailover(e);
            if (this.failoverCallback != null) {
                this.failoverCallback.accept(e);
            }
            return this.failoverRealm.getRealmIdentity(evidence);
        }
    }

    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        try {
            return this.createFailoverIdentity(this.delegateRealm.getRealmIdentity(principal), principal);
        }
        catch (RealmUnavailableException e) {
            ElytronMessages.log.realmFailover(e);
            if (this.failoverCallback != null) {
                this.failoverCallback.accept(e);
            }
            return this.failoverRealm.getRealmIdentity(principal);
        }
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        try {
            return this.delegateRealm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }
        catch (RealmUnavailableException rue) {
            ElytronMessages.log.realmFailover(rue);
            if (this.failoverCallback != null) {
                this.failoverCallback.accept(rue);
            }
            return SupportLevel.POSSIBLY_SUPPORTED;
        }
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        try {
            return this.delegateRealm.getEvidenceVerifySupport(evidenceType, algorithmName);
        }
        catch (RealmUnavailableException rue) {
            ElytronMessages.log.realmFailover(rue);
            if (this.failoverCallback != null) {
                this.failoverCallback.accept(rue);
            }
            return SupportLevel.POSSIBLY_SUPPORTED;
        }
    }

    protected RealmIdentity createFailoverIdentity(RealmIdentity identity, final Evidence evidence) {
        return new FailoverRealmIdentity(identity){

            @Override
            protected RealmIdentity getFailoverIdentity() throws RealmUnavailableException {
                return FailoverSecurityRealm.this.failoverRealm.getRealmIdentity(evidence);
            }
        };
    }

    protected RealmIdentity createFailoverIdentity(RealmIdentity identity, final Principal principal) {
        return new FailoverRealmIdentity(identity){

            @Override
            protected RealmIdentity getFailoverIdentity() throws RealmUnavailableException {
                return FailoverSecurityRealm.this.failoverRealm.getRealmIdentity(principal);
            }
        };
    }

    protected abstract class FailoverRealmIdentity
    implements RealmIdentity {
        protected RealmIdentity delegate;
        protected boolean failed = false;

        protected FailoverRealmIdentity(RealmIdentity identity) {
            this.delegate = identity;
        }

        protected abstract RealmIdentity getFailoverIdentity() throws RealmUnavailableException;

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            try {
                return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }
            catch (RealmUnavailableException rue) {
                return this.failover(rue).getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            try {
                Credential credential = this.delegate.getCredential(credentialType);
                return (C)credential;
            }
            catch (RealmUnavailableException rue) {
                Credential credential = this.failover(rue).getCredential(credentialType);
                return (C)credential;
            }
            finally {
                this.disableFailover();
            }
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            try {
                return this.delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
            catch (RealmUnavailableException rue) {
                return this.failover(rue).getEvidenceVerifySupport(evidenceType, algorithmName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            try {
                boolean bl = this.delegate.verifyEvidence(evidence);
                return bl;
            }
            catch (RealmUnavailableException rue) {
                boolean bl = this.failover(rue).verifyEvidence(evidence);
                return bl;
            }
            finally {
                this.disableFailover();
            }
        }

        public boolean exists() throws RealmUnavailableException {
            try {
                boolean bl = this.delegate.exists();
                return bl;
            }
            catch (RealmUnavailableException rue) {
                boolean bl = this.failover(rue).exists();
                return bl;
            }
            finally {
                this.disableFailover();
            }
        }

        public void updateCredential(Credential credential) throws RealmUnavailableException {
            try {
                this.delegate.updateCredential(credential);
            }
            catch (RealmUnavailableException rue) {
                this.failover(rue).updateCredential(credential);
            }
            finally {
                this.disableFailover();
            }
        }

        public Principal getRealmIdentityPrincipal() {
            return this.delegate.getRealmIdentityPrincipal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            try {
                Credential credential = this.delegate.getCredential(credentialType, algorithmName);
                return (C)credential;
            }
            catch (RealmUnavailableException rue) {
                Credential credential = this.failover(rue).getCredential(credentialType, algorithmName);
                return (C)credential;
            }
            finally {
                this.disableFailover();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            try {
                Credential credential = this.delegate.getCredential(credentialType, algorithmName, parameterSpec);
                return (C)credential;
            }
            catch (RealmUnavailableException rue) {
                Credential credential = this.failover(rue).getCredential(credentialType, algorithmName, parameterSpec);
                return (C)credential;
            }
            finally {
                this.disableFailover();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
            try {
                Object object = this.delegate.applyToCredential(credentialType, function);
                return (R)object;
            }
            catch (RealmUnavailableException rue) {
                Object object = this.failover(rue).applyToCredential(credentialType, function);
                return (R)object;
            }
            finally {
                this.disableFailover();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
            try {
                Object object = this.delegate.applyToCredential(credentialType, algorithmName, function);
                return (R)object;
            }
            catch (RealmUnavailableException rue) {
                Object object = this.failover(rue).applyToCredential(credentialType, algorithmName, function);
                return (R)object;
            }
            finally {
                this.disableFailover();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) throws RealmUnavailableException {
            try {
                Object object = this.delegate.applyToCredential(credentialType, algorithmName, parameterSpec, function);
                return (R)object;
            }
            catch (RealmUnavailableException rue) {
                Object object = this.failover(rue).applyToCredential(credentialType, algorithmName, parameterSpec, function);
                return (R)object;
            }
            finally {
                this.disableFailover();
            }
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            try {
                AuthorizationIdentity authorizationIdentity = this.delegate.getAuthorizationIdentity();
                return authorizationIdentity;
            }
            catch (RealmUnavailableException rue) {
                AuthorizationIdentity authorizationIdentity = this.failover(rue).getAuthorizationIdentity();
                return authorizationIdentity;
            }
            finally {
                this.disableFailover();
            }
        }

        public Attributes getAttributes() throws RealmUnavailableException {
            return this.delegate.getAttributes();
        }

        protected RealmIdentity failover(RealmUnavailableException rue) throws RealmUnavailableException {
            if (this.failed) {
                throw rue;
            }
            ElytronMessages.log.realmFailover(rue);
            if (FailoverSecurityRealm.this.failoverCallback != null) {
                FailoverSecurityRealm.this.failoverCallback.accept(rue);
            }
            this.failed = true;
            this.delegate.dispose();
            this.delegate = this.getFailoverIdentity();
            return this.delegate;
        }

        protected void disableFailover() {
            this.failed = true;
        }
    }
}

