/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import com.carrotsearch.hppc.IntObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.ExplicitDocIdsQuery;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.HibernateSearchMultiCollectorManager;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.query.spi.SimpleSearchResultTotal;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneCollectors {
    static final CollectorKey<TotalHitCountCollector, Integer> TOTAL_HIT_COUNT_KEY = CollectorKey.create();
    static final CollectorKey<TopDocsCollector<?>, TopDocs> TOP_DOCS_KEY = CollectorKey.create();
    private final IndexReaderMetadataResolver metadataResolver;
    private final IndexSearcher indexSearcher;
    private final Query rewrittenLuceneQuery;
    private final Query originalLuceneQuery;
    private final boolean requireFieldDocRescoring;
    private final Integer scoreSortFieldIndexForRescoring;
    private final HibernateSearchMultiCollectorManager collectorsForAllMatchingDocs;
    private final StoredFieldsValuesDelegate.Factory storedFieldsValuesDelegateOrNull;
    private final TimeoutManager timeoutManager;
    private SearchResultTotal resultTotal;
    private TopDocs topDocs = null;
    private HibernateSearchMultiCollectorManager.MultiCollectedResults results = HibernateSearchMultiCollectorManager.MultiCollectedResults.EMPTY;

    LuceneCollectors(IndexReaderMetadataResolver metadataResolver, IndexSearcher indexSearcher, Query rewrittenLuceneQuery, Query originalLuceneQuery, boolean requireFieldDocRescoring, Integer scoreSortFieldIndexForRescoring, HibernateSearchMultiCollectorManager collectorsForAllMatchingDocs, StoredFieldsValuesDelegate.Factory storedFieldsValuesDelegateOrNull, TimeoutManager timeoutManager) {
        this.metadataResolver = metadataResolver;
        this.indexSearcher = indexSearcher;
        this.rewrittenLuceneQuery = rewrittenLuceneQuery;
        this.originalLuceneQuery = originalLuceneQuery;
        this.requireFieldDocRescoring = requireFieldDocRescoring;
        this.scoreSortFieldIndexForRescoring = scoreSortFieldIndexForRescoring;
        this.collectorsForAllMatchingDocs = collectorsForAllMatchingDocs;
        this.storedFieldsValuesDelegateOrNull = storedFieldsValuesDelegateOrNull;
        this.timeoutManager = timeoutManager;
    }

    public void collectMatchingDocs() throws IOException {
        if (this.timeoutManager.checkTimedOut()) {
            this.resultTotal = SimpleSearchResultTotal.lowerBound((long)0L);
            return;
        }
        if (this.collectorsForAllMatchingDocs != null) {
            HibernateSearchMultiCollectorManager.HibernateSearchQueryTimeout timeout = this.collectorsForAllMatchingDocs.queryTimeout();
            this.indexSearcher.setTimeout((QueryTimeout)timeout);
            HibernateSearchMultiCollectorManager.MultiCollectedResults collectedResults = (HibernateSearchMultiCollectorManager.MultiCollectedResults)this.indexSearcher.search(this.rewrittenLuceneQuery, (CollectorManager)this.collectorsForAllMatchingDocs);
            if (LuceneCollectors.canSafelyCollectResults(timeout)) {
                this.results = collectedResults;
            }
        }
        this.processCollectedMatchingDocs();
    }

    private void processCollectedMatchingDocs() throws IOException {
        if (this.rewrittenLuceneQuery instanceof MatchAllDocsQuery) {
            this.resultTotal = SimpleSearchResultTotal.exact((long)this.indexSearcher.getIndexReader().numDocs());
        } else {
            Integer total = this.results.get(TOTAL_HIT_COUNT_KEY);
            if (total != null) {
                boolean exact = !this.timeoutManager.isTimedOut();
                this.resultTotal = SimpleSearchResultTotal.of((long)total.intValue(), (boolean)exact);
            }
        }
        this.topDocs = this.results.get(TOP_DOCS_KEY);
        if (this.topDocs == null) {
            if (this.resultTotal == null) {
                this.resultTotal = SimpleSearchResultTotal.lowerBound((long)0L);
            }
            return;
        }
        if (this.resultTotal == null) {
            boolean exact = TotalHits.Relation.EQUAL_TO.equals((Object)this.topDocs.totalHits.relation) && !this.timeoutManager.isTimedOut();
            this.resultTotal = SimpleSearchResultTotal.of((long)this.topDocs.totalHits.value, (boolean)exact);
        } else if (this.resultTotal.isHitCountExact()) {
            this.topDocs.totalHits = new TotalHits(this.resultTotal.hitCount(), TotalHits.Relation.EQUAL_TO);
        }
        if (this.requireFieldDocRescoring) {
            this.handleRescoring();
        }
    }

    public HibernateSearchMultiCollectorManager.MultiCollectedResults collectedMultiResults() {
        return this.results;
    }

    public <T> List<T> collectTopDocsData(TopDocsDataCollector.Factory<T> collectorFactory, int startInclusive, int endExclusive) throws IOException {
        ArrayList<Object> extractedData = new ArrayList<Object>(endExclusive - startInclusive);
        ScoreDoc[] scoreDocs = this.topDocs.scoreDocs;
        ExplicitDocIdsQuery topDocsQuery = new ExplicitDocIdsQuery(scoreDocs, startInclusive, endExclusive);
        HibernateSearchMultiCollectorManager collectorManager = this.buildTopDocsDataCollectors(collectorFactory);
        HibernateSearchMultiCollectorManager.HibernateSearchQueryTimeout timeout = collectorManager.queryTimeout();
        this.indexSearcher.setTimeout((QueryTimeout)timeout);
        HibernateSearchMultiCollectorManager.MultiCollectedResults collectedResults = (HibernateSearchMultiCollectorManager.MultiCollectedResults)this.indexSearcher.search((Query)topDocsQuery, (CollectorManager)collectorManager);
        if (LuceneCollectors.canSafelyCollectResults(timeout)) {
            IntObjectMap collected = (IntObjectMap)collectedResults.get(collectorFactory);
            for (int i = startInclusive; i < endExclusive; ++i) {
                extractedData.add(collected.get(scoreDocs[i].doc));
            }
        }
        return extractedData;
    }

    public SearchResultTotal getResultTotal() {
        return this.resultTotal;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    private void handleRescoring() throws IOException {
        if (this.scoreSortFieldIndexForRescoring != null) {
            for (ScoreDoc scoreDoc : this.topDocs.scoreDocs) {
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                fieldDoc.score = ((Float)fieldDoc.fields[this.scoreSortFieldIndexForRescoring]).floatValue();
            }
        } else {
            TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)this.indexSearcher, (Query)this.rewrittenLuceneQuery);
        }
    }

    private <T> HibernateSearchMultiCollectorManager buildTopDocsDataCollectors(TopDocsDataCollector.Factory<T> collectorManagerFactory) throws IOException {
        TopDocsDataCollectorExecutionContext executionContext = new TopDocsDataCollectorExecutionContext(this.metadataResolver, this.indexSearcher, this.rewrittenLuceneQuery, this.originalLuceneQuery, this.topDocs, this.storedFieldsValuesDelegateOrNull);
        HibernateSearchMultiCollectorManager.Builder collectorForTopDocsBuilder = new HibernateSearchMultiCollectorManager.Builder(executionContext, this.timeoutManager);
        collectorForTopDocsBuilder.add(collectorManagerFactory, collectorManagerFactory.create(executionContext));
        return collectorForTopDocsBuilder.build();
    }

    private static boolean canSafelyCollectResults(HibernateSearchMultiCollectorManager.HibernateSearchQueryTimeout timeout) {
        return timeout == null || !timeout.isReached();
    }
}

