/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ejb3.iiop.ReferenceFactory;
import org.jboss.as.ejb3.iiop.ServantRegistry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class POARegistry
implements Service<POARegistry> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "iiop", "POARegistry"});
    public static final byte[] EMPTY_BYTES = new byte[0];
    private final InjectedValue<POA> rootPOA = new InjectedValue();
    private ServantRegistry registryWithTransientPOAPerServant;
    private Map<String, POA> transientPoaMap;
    private Policy[] transientPoaPolicies;
    private ServantRegistry registryWithPersistentPOAPerServant;
    private Map<String, POA> persistentPoaMap;
    private Policy[] persistentPoaPolicies;

    public synchronized void start(StartContext startContext) throws StartException {
        this.transientPoaMap = Collections.synchronizedMap(new HashMap());
        this.persistentPoaMap = Collections.synchronizedMap(new HashMap());
        POA rootPOA = (POA)this.rootPOA.getValue();
        this.transientPoaPolicies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        this.persistentPoaPolicies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        this.registryWithTransientPOAPerServant = new ServantRegistryWithTransientPOAPerServant();
        this.registryWithPersistentPOAPerServant = new ServantRegistryWithPersistentPOAPerServant();
    }

    public synchronized void stop(StopContext context) {
        this.transientPoaMap = null;
        this.persistentPoaMap = null;
        this.transientPoaPolicies = null;
        this.persistentPoaPolicies = null;
    }

    private static Policy[] concatPolicies(Policy[] policies1, Policy[] policies2) {
        Policy[] policies = new Policy[policies1.length + policies2.length];
        int j = 0;
        int i = 0;
        while (i < policies1.length) {
            policies[j] = policies1[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < policies2.length) {
            policies[j] = policies2[i];
            ++i;
            ++j;
        }
        return policies;
    }

    public synchronized POARegistry getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServantRegistry getRegistryWithTransientPOAPerServant() {
        return this.registryWithTransientPOAPerServant;
    }

    public ServantRegistry getRegistryWithPersistentPOAPerServant() {
        return this.registryWithPersistentPOAPerServant;
    }

    public InjectedValue<POA> getRootPOA() {
        return this.rootPOA;
    }

    class ServantRegistryWithTransientPOAPerServant
    implements ServantRegistry {
        ServantRegistryWithTransientPOAPerServant() {
        }

        @Override
        public ReferenceFactory bind(String name, Servant servant, Policy[] policies) throws Exception {
            Policy[] poaPolicies = POARegistry.concatPolicies(POARegistry.this.transientPoaPolicies, policies);
            POA poa = ((POA)POARegistry.this.rootPOA.getValue()).create_POA(name, null, poaPolicies);
            POARegistry.this.transientPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        @Override
        public ReferenceFactory bind(String name, Servant servant) throws Exception {
            POA poa = ((POA)POARegistry.this.rootPOA.getValue()).create_POA(name, null, POARegistry.this.transientPoaPolicies);
            POARegistry.this.transientPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        @Override
        public void unbind(String name) throws Exception {
            POA poa = POARegistry.this.transientPoaMap.remove(name);
            if (poa != null) {
                poa.the_POAManager().deactivate(false, true);
                poa.destroy(false, true);
            }
        }
    }

    class ServantRegistryWithPersistentPOAPerServant
    implements ServantRegistry {
        ServantRegistryWithPersistentPOAPerServant() {
        }

        @Override
        public ReferenceFactory bind(String name, Servant servant, Policy[] policies) throws Exception {
            Policy[] poaPolicies = POARegistry.concatPolicies(POARegistry.this.persistentPoaPolicies, policies);
            POA poa = ((POA)POARegistry.this.rootPOA.getValue()).create_POA(name, null, poaPolicies);
            POARegistry.this.persistentPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        @Override
        public ReferenceFactory bind(String name, Servant servant) throws Exception {
            POA poa = ((POA)POARegistry.this.rootPOA.getValue()).create_POA(name, null, POARegistry.this.persistentPoaPolicies);
            POARegistry.this.persistentPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        @Override
        public void unbind(String name) throws Exception {
            POA poa = POARegistry.this.persistentPoaMap.remove(name);
            if (poa != null) {
                poa.the_POAManager().deactivate(false, true);
                poa.destroy(false, true);
            }
        }
    }

    static class PoaReferenceFactory
    implements ReferenceFactory {
        private final POA poa;
        private final Policy[] policies;

        PoaReferenceFactory(POA poa, Policy[] policies) {
            this.poa = poa;
            this.policies = policies;
        }

        PoaReferenceFactory(POA poa) {
            this(poa, null);
        }

        @Override
        public Object createReference(String interfId) throws Exception {
            Object corbaRef = this.poa.create_reference_with_id(EMPTY_BYTES, interfId);
            if (this.policies != null) {
                return corbaRef._set_policy_override(this.policies, SetOverrideType.ADD_OVERRIDE);
            }
            return corbaRef;
        }

        @Override
        public Object createReferenceWithId(byte[] id, String interfId) throws Exception {
            Object corbaRef = this.poa.create_reference_with_id(id, interfId);
            if (this.policies != null) {
                return corbaRef._set_policy_override(this.policies, SetOverrideType.ADD_OVERRIDE);
            }
            return corbaRef;
        }

        @Override
        public POA getPOA() {
            return this.poa;
        }
    }
}

