/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class CompositeServiceBuilder<T>
extends DelegatingServiceBuilder<T> {
    private final Iterable<ServiceBuilder<?>> builders;

    public CompositeServiceBuilder(Iterable<ServiceBuilder<?>> builders) {
        super(null);
        this.builders = builders;
    }

    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        for (ServiceBuilder<?> builder : this.builders) {
            builder.setInitialMode(mode);
        }
        return this;
    }

    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        for (ServiceBuilder<?> builder : this.builders) {
            builder.addListener(listener);
        }
        return this;
    }

    public ServiceController<T> install() {
        LinkedList<ServiceController> controllers = new LinkedList<ServiceController>();
        for (ServiceBuilder<?> builder : this.builders) {
            controllers.add(builder.install());
        }
        return !controllers.isEmpty() ? (ServiceController)controllers.get(0) : null;
    }

    public <V> Supplier<V> requires(ServiceName name) {
        throw new UnsupportedOperationException();
    }

    public <V> Consumer<V> provides(ServiceName ... names) {
        throw new UnsupportedOperationException();
    }

    public ServiceBuilder<T> setInstance(Service service) {
        throw new UnsupportedOperationException();
    }
}

