/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;

public interface ResourceServiceHandler {
    public void installServices(OperationContext var1, ModelNode var2) throws OperationFailedException;

    public void removeServices(OperationContext var1, ModelNode var2) throws OperationFailedException;

    public static ResourceServiceHandler of(ResourceOperationRuntimeHandler ... handlers) {
        return ResourceServiceHandler.of(List.of(handlers));
    }

    public static ResourceServiceHandler of(final Iterable<? extends ResourceOperationRuntimeHandler> handlers) {
        return new ResourceServiceHandler(){

            @Override
            public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
                for (ResourceOperationRuntimeHandler handler : handlers) {
                    handler.addRuntime(context, model);
                }
            }

            @Override
            public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
                for (ResourceOperationRuntimeHandler handler : handlers) {
                    handler.removeRuntime(context, model);
                }
            }
        };
    }
}

