/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.delivery.parser;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.ejb3.delivery.metadata.EJBBoundMdbDeliveryMetaData;
import org.jboss.as.ejb3.delivery.parser.EjbBoundMdbDeliveryMetaDataSchema;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaData;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;

public class EJBBoundMdbDeliveryMetaDataParser
extends AbstractEJBBoundMetaDataParser<EJBBoundMdbDeliveryMetaData> {
    private static final String ROOT_ELEMENT_DELIVERY = "delivery";
    private static final String ACTIVE = "active";
    private static final String GROUP = "group";
    private final EjbBoundMdbDeliveryMetaDataSchema schema;

    public EJBBoundMdbDeliveryMetaDataParser(EjbBoundMdbDeliveryMetaDataSchema schema) {
        this.schema = schema;
    }

    public EJBBoundMdbDeliveryMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (!ROOT_ELEMENT_DELIVERY.equals(reader.getLocalName())) {
            throw EJBBoundMdbDeliveryMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        EJBBoundMdbDeliveryMetaData metaData = new EJBBoundMdbDeliveryMetaData();
        this.processElements(metaData, reader, propertyReplacer);
        return metaData;
    }

    protected void processElement(EJBBoundMdbDeliveryMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (this.schema.getNamespace().getUri().equals(reader.getNamespaceURI())) {
            String localName;
            switch (localName = reader.getLocalName()) {
                case "active": {
                    String val = EJBBoundMdbDeliveryMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                    metaData.setDeliveryActive(Boolean.parseBoolean(val.trim()));
                    break;
                }
                case "group": {
                    if (this.schema.since((VersionedFeature)EjbBoundMdbDeliveryMetaDataSchema.VERSION_1_2)) {
                        String deliveryGroup = EJBBoundMdbDeliveryMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer).trim();
                        if (metaData.getDeliveryGroups() == null) {
                            metaData.setDeliveryGroups(deliveryGroup);
                            break;
                        }
                        ArrayList<String> deliveryGroups = new ArrayList<String>(metaData.getDeliveryGroups().length + 1);
                        Collections.addAll(deliveryGroups, metaData.getDeliveryGroups());
                        deliveryGroups.add(deliveryGroup);
                        metaData.setDeliveryGroups(deliveryGroups.toArray(new String[deliveryGroups.size()]));
                        break;
                    }
                    if (this.schema.since((VersionedFeature)EjbBoundMdbDeliveryMetaDataSchema.VERSION_1_1)) {
                        metaData.setDeliveryGroups(EJBBoundMdbDeliveryMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer).trim());
                        break;
                    }
                }
                default: {
                    throw EJBBoundMdbDeliveryMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
        } else {
            super.processElement((AbstractEJBBoundMetaData)metaData, reader, propertyReplacer);
        }
    }
}

