/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.servlet.api.Deployment;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.wildfly.clustering.cache.batch.BatchContextualizerFactory;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ContextualizerFactory;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.undertow.session.DistributableImmutableSession;
import org.wildfly.clustering.web.undertow.session.Recordable;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class UndertowSessionExpirationListener
implements Consumer<ImmutableSession> {
    private static final ContextualizerFactory BATCH_CONTEXTUALIZER_FACTORY = (ContextualizerFactory)ServiceLoader.load(BatchContextualizerFactory.class, BatchContextualizerFactory.class.getClassLoader()).findFirst().orElseThrow();
    private final Deployment deployment;
    private final SessionListeners listeners;
    private final Recordable<ImmutableSessionMetaData> recorder;

    public UndertowSessionExpirationListener(Deployment deployment, SessionListeners listeners, Recordable<ImmutableSessionMetaData> recorder) {
        this.deployment = deployment;
        this.listeners = listeners;
        this.recorder = recorder;
    }

    @Override
    public void accept(ImmutableSession session) {
        if (this.recorder != null) {
            this.recorder.record(session.getMetaData());
        }
        UndertowSessionManager manager = (UndertowSessionManager)this.deployment.getSessionManager();
        DistributableImmutableSession undertowSession = new DistributableImmutableSession(manager, session);
        Contextualizer contextualizer = BATCH_CONTEXTUALIZER_FACTORY.createContextualizer(this.deployment.getServletContext().getClassLoader());
        Consumer<Session> notifier = this::notify;
        contextualizer.contextualize(notifier).accept(undertowSession);
        for (Map.Entry entry : session.getAttributes().entrySet()) {
            manager.getSessionListeners().attributeRemoved((Session)undertowSession, (String)entry.getKey(), entry.getValue());
        }
    }

    private void notify(Session session) {
        this.listeners.sessionDestroyed(session, null, SessionListener.SessionDestroyedReason.TIMEOUT);
    }
}

