/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource;

import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class SimpleResource
implements Resource {
    private final ModelNode model;

    public SimpleResource(ModelNode model) {
        this.model = model;
    }

    public ModelNode getModel() {
        return this.model;
    }

    public void writeModel(ModelNode newModel) {
        if (newModel != this.model) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isModelDefined() {
        return this.model.isDefined();
    }

    public boolean hasChild(PathElement element) {
        return false;
    }

    public Resource getChild(PathElement element) {
        return null;
    }

    public Resource requireChild(PathElement element) {
        throw new Resource.NoSuchResourceException(element);
    }

    public boolean hasChildren(String childType) {
        return false;
    }

    public Resource navigate(PathAddress address) {
        if (address.size() == 0) {
            return this;
        }
        throw new Resource.NoSuchResourceException(address.getElement(0));
    }

    public Set<String> getChildTypes() {
        return Set.of();
    }

    public Set<String> getChildrenNames(String childType) {
        return Set.of();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        return Set.of();
    }

    public void registerChild(PathElement address, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public Resource removeChild(PathElement address) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getOrderedChildTypes() {
        return Set.of();
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        return new SimpleResource(this.model.clone());
    }
}

