/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.coordinator.service;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import io.narayana.lra.coordinator.internal.Implementations;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.lra.coordinator._private.MicroProfileLRACoordinatorLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LRARecoveryService
implements Service {
    private static final Logger log = Logger.getLogger(LRARecoveryService.class);
    private final Supplier<ExecutorService> executorSupplier;
    private volatile LRARecoveryModule lraRecoveryModule;

    public LRARecoveryService(Supplier<ExecutorService> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRecoveryScan(StartContext context) {
        assert (this.executorSupplier != null);
        ExecutorService service = this.executorSupplier.get();
        Runnable task = () -> {
            try {
                this.lraRecoveryModule.periodicWorkSecondPass();
                context.complete();
            }
            catch (Exception e) {
                MicroProfileLRACoordinatorLogger.LOGGER.failedToRunRecoveryScan("/lra-coordinator", e);
            }
        };
        try {
            service.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        Implementations.install();
        ClassLoader loader = LRARecoveryService.class.getClassLoader();
        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)loader);
        try {
            try {
                this.lraRecoveryModule = LRARecoveryModule.getInstance();
                if (RecoveryManager.manager().getModules().stream().noneMatch(rm -> rm instanceof LRARecoveryModule)) {
                    RecoveryManager.manager().addModule((RecoveryModule)this.lraRecoveryModule);
                }
                this.startRecoveryScan(context);
            }
            catch (Exception e) {
                throw MicroProfileLRACoordinatorLogger.LOGGER.lraRecoveryServiceFailedToStart();
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)null);
        }
    }

    public synchronized void stop(StopContext context) {
        Implementations.uninstall();
        if (this.lraRecoveryModule != null) {
            RecoveryManager recoveryManager = RecoveryManager.manager();
            try {
                recoveryManager.removeModule((RecoveryModule)this.lraRecoveryModule, false);
            }
            catch (Exception e) {
                log.debugf("Cannot remove LRA recovery module %s while stopping %s", (Object)this.lraRecoveryModule.getClass().getName(), (Object)LRARecoveryService.class.getName());
            }
        }
    }
}

