/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.AffinityPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ModulesServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.infinispan.cache.LazyCache;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HotRodStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.NoStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.OffHeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.service.CacheServiceInstallerFactory;
import org.wildfly.clustering.infinispan.service.ConfigurationServiceInstallerFactory;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteredCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LocalCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.ProvidedBinaryServiceInstallerProvider;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class CacheResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator,
ResourceModelResolver<Map.Entry<Consumer<ConfigurationBuilder>, Stream<Consumer<RequirementServiceBuilder<?>>>>> {
    static final BinaryServiceDescriptor<List<Module>> CACHE_MODULES = BinaryServiceDescriptor.of((String)"org.wildfly.clustering.infinispan.cache-modules", List.class);
    private static final RuntimeCapability<Void> CACHE_CAPABILITY = RuntimeCapability.Builder.of((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE).setAllowMultipleRegistrations(true).build();
    static final RuntimeCapability<Void> CACHE_CONFIGURATION_CAPABILITY = RuntimeCapability.Builder.of((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONFIGURATION).setAllowMultipleRegistrations(true).build();
    private static final RuntimeCapability<Void> CACHE_MODULES_CAPABILITY = RuntimeCapability.Builder.of(CACHE_MODULES).setAllowMultipleRegistrations(true).build();
    static final Set<PathElement> REQUIRED_CHILDREN = Set.of(ExpirationResourceDefinition.PATH, LockingResourceDefinition.PATH, TransactionResourceDefinition.PATH);
    static final Set<PathElement> REQUIRED_SINGLETON_CHILDREN = Set.of(HeapMemoryResourceDefinition.PATH, NoStoreResourceDefinition.PATH);
    private final UnaryOperator<ResourceDescriptor> configurator;
    private final CacheMode mode;

    static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type) {
        return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false);
    }

    public CacheResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, CacheMode mode, FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(path, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, PathElement.pathElement((String)"cache")));
        this.configurator = configurator;
        this.mode = mode;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        RuntimeCapability registryFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)ClusteringServiceDescriptor.REGISTRY_FACTORY).build();
        RuntimeCapability legacyRegistryFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)LegacyClusteringServiceDescriptor.REGISTRY_FACTORY).build();
        RuntimeCapability serviceProviderRegistrar = RuntimeCapability.Builder.of((BinaryServiceDescriptor)ClusteringServiceDescriptor.SERVICE_PROVIDER_REGISTRAR).build();
        RuntimeCapability legacyServiceProviderRegistry = RuntimeCapability.Builder.of((BinaryServiceDescriptor)LegacyClusteringServiceDescriptor.SERVICE_PROVIDER_REGISTRY).build();
        RuntimeCapability singletonServiceTargetFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)SingletonServiceTargetFactory.SERVICE_DESCRIPTOR).build();
        RuntimeCapability singletonServiceConfiguratorFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)SingletonServiceConfiguratorFactory.SERVICE_DESCRIPTOR).build();
        RuntimeCapability singletonServiceBuilderFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)SingletonServiceBuilderFactory.SERVICE_DESCRIPTOR).build();
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addAttributes(Attribute.class).addAttributes(ListAttribute.class).addCapabilities(List.of(CACHE_CAPABILITY, CACHE_CONFIGURATION_CAPABILITY, CACHE_MODULES_CAPABILITY, registryFactory, legacyRegistryFactory, serviceProviderRegistrar, legacyServiceProviderRegistry, singletonServiceTargetFactory, singletonServiceConfiguratorFactory, singletonServiceBuilderFactory)).addRequiredChildren(REQUIRED_CHILDREN).addRequiredSingletonChildren(REQUIRED_SINGLETON_CHILDREN);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new HeapMemoryResourceDefinition().register(registration);
        new OffHeapMemoryResourceDefinition().register(registration);
        new ExpirationResourceDefinition().register(registration);
        new LockingResourceDefinition().register(registration);
        new TransactionResourceDefinition().register(registration);
        new NoStoreResourceDefinition().register(registration);
        new CustomStoreResourceDefinition().register(registration);
        new FileStoreResourceDefinition().register(registration);
        new JDBCStoreResourceDefinition().register(registration);
        new RemoteStoreResourceDefinition().register(registration);
        new HotRodStoreResourceDefinition().register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        final String cacheName = address.getLastElement().getValue();
        BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)containerName, (String)cacheName);
        LinkedList<Object> installers = new LinkedList<Object>();
        if (model.hasDefined(ListAttribute.MODULES.getName())) {
            installers.add(new ModulesServiceConfigurator(CACHE_MODULES_CAPABILITY, ListAttribute.MODULES.getDefinition(), List.of()).configure(context, model));
        } else {
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(CACHE_MODULES_CAPABILITY, (ServiceDependency)configuration.getServiceDependency(CacheContainerResourceDefinition.CACHE_CONTAINER_MODULES)).build());
        }
        MapEntry<Consumer<ConfigurationBuilder>, Stream<Consumer<RequirementServiceBuilder<?>>>> entry = this.resolve(context, model);
        installers.add(new ConfigurationServiceInstallerFactory((Consumer)entry.getKey(), (Iterable)((Stream)entry.getValue()).collect(Collectors.toList())).apply(configuration));
        installers.add(CacheServiceInstallerFactory.INSTANCE.apply(configuration));
        ServiceName lazyCacheServiceName = CACHE_CAPABILITY.getCapabilityServiceName(address).append(new String[]{"lazy"});
        final ServiceDependency container = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER);
        Supplier factory = new Supplier<Cache<?, ?>>(){

            @Override
            public Cache<?, ?> get() {
                return new LazyCache((EmbeddedCacheManager)container.get(), cacheName);
            }
        };
        installers.add((ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(lazyCacheServiceName)).requires(List.of(container, configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE)))).build());
        installers.add(new BinderServiceInstaller(InfinispanBindingFactory.createCacheConfigurationBinding(configuration), CACHE_CONFIGURATION_CAPABILITY.getCapabilityServiceName(address)));
        installers.add(new BinderServiceInstaller(InfinispanBindingFactory.createCacheBinding(configuration), lazyCacheServiceName));
        Class providerClass = this.mode.isClustered() ? ClusteredCacheServiceInstallerProvider.class : LocalCacheServiceInstallerProvider.class;
        new ProvidedBinaryServiceInstallerProvider(providerClass, providerClass.getClassLoader()).apply(context.getCapabilityServiceSupport(), configuration).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }

    public MapEntry<Consumer<ConfigurationBuilder>, Stream<Consumer<RequirementServiceBuilder<?>>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String containerName = address.getParent().getLastElement().getValue();
        String cacheName = address.getLastElement().getValue();
        final CacheMode mode = this.mode;
        final boolean statisticsEnabled = Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final ServiceDependency memory = ServiceDependency.on(MemoryResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency expiration = ServiceDependency.on(ExpirationResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency locking = ServiceDependency.on(LockingResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency persistence = ServiceDependency.on(StoreResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency transaction = ServiceDependency.on(TransactionResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        return MapEntry.of((Object)new Consumer<ConfigurationBuilder>(){

            @Override
            public void accept(ConfigurationBuilder builder) {
                TransactionConfiguration tx = (TransactionConfiguration)transaction.get();
                builder.clustering().cacheMode(mode).hash().keyPartitioner((KeyPartitioner)new AffinityPartitioner());
                builder.memory().read((Object)((MemoryConfiguration)memory.get()));
                builder.expiration().read((Object)((ExpirationConfiguration)expiration.get()));
                builder.locking().read((Object)((LockingConfiguration)locking.get()));
                builder.persistence().read((Object)((PersistenceConfiguration)persistence.get()));
                builder.transaction().read((Object)tx);
                builder.statistics().enabled(statisticsEnabled);
                try {
                    builder.invocationBatching().enable(tx.transactionMode().isTransactional() && tx.transactionManagerLookup().getTransactionManager() == EmbeddedTransactionManager.getInstance());
                }
                catch (Exception e) {
                    throw new CacheConfigurationException(e);
                }
            }
        }, Stream.of(memory, expiration, locking, persistence, transaction));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(ModelNode.FALSE);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)this.apply(CacheResourceDefinition.createBuilder(name, type))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ListAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<StringListAttributeDefinition.Builder>
    {
        MODULES("modules"){

            @Override
            public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
                return (StringListAttributeDefinition.Builder)builder.setElementValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        };

        private final AttributeDefinition definition;

        private ListAttribute(String name) {
            this.definition = this.apply((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
            return builder;
        }
    }
}

