/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnycastTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SimpleString baseAddress = SimpleString.of((String)"anycast.address");
    private AddressInfo addressInfo;
    private ActiveMQServer server;
    private ClientSessionFactory sessionFactory;

    @BeforeEach
    public void setup() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        ServerLocator sl = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.sessionFactory = sl.createSessionFactory();
        this.addSessionFactory(this.sessionFactory);
        this.addressInfo = new AddressInfo(this.baseAddress);
        this.addressInfo.addRoutingType(RoutingType.ANYCAST);
        this.server.addOrUpdateAddressInfo(this.addressInfo);
    }

    @Test
    public void testTxCommitReceive() throws Exception {
        Queue q1 = this.server.createQueue(QueueConfiguration.of((SimpleString)this.baseAddress.concat(".1")).setAddress(this.baseAddress).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        Queue q2 = this.server.createQueue(QueueConfiguration.of((SimpleString)this.baseAddress.concat(".2")).setAddress(this.baseAddress).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        ClientSession session = this.sessionFactory.createSession(false, false);
        session.start();
        ClientConsumer consumer1 = session.createConsumer(q1.getName());
        ClientConsumer consumer2 = session.createConsumer(q2.getName());
        ClientProducer producer = session.createProducer(this.baseAddress);
        int num = 10;
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = session.createMessage((byte)3, true);
            m.getBodyBuffer().writeString("AnyCast" + i);
            producer.send((Message)m);
        }
        Assertions.assertNull((Object)consumer1.receive(200L));
        Assertions.assertNull((Object)consumer2.receive(200L));
        session.commit();
        Assertions.assertTrue((boolean)TimeUtils.waitOnBoolean((boolean)true, (long)2000L, () -> 5L == q1.getMessageCount()));
        Assertions.assertTrue((boolean)TimeUtils.waitOnBoolean((boolean)true, (long)2000L, () -> 5L == q2.getMessageCount()));
        ClientConsumer[] consumers = new ClientConsumer[]{consumer1, consumer2};
        for (int i = 0; i < consumers.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                ClientMessage m = consumers[i].receive(2000L);
                Assertions.assertNotNull((Object)m);
                logger.debug("consumer{} received: {}", (Object)i, (Object)m.getBodyBuffer().readString());
            }
            Assertions.assertNull((Object)consumers[i].receive(200L));
            session.commit();
            Assertions.assertNull((Object)consumers[i].receive(200L));
        }
        q1.deleteQueue();
        q2.deleteQueue();
    }

    @Test
    public void testTxRollbackReceive() throws Exception {
        Queue q1 = this.server.createQueue(QueueConfiguration.of((SimpleString)this.baseAddress.concat(".1")).setAddress(this.baseAddress).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        Queue q2 = this.server.createQueue(QueueConfiguration.of((SimpleString)this.baseAddress.concat(".2")).setAddress(this.baseAddress).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(-1)));
        ClientSession session = this.sessionFactory.createSession(false, false);
        session.start();
        ClientConsumer consumer1 = session.createConsumer(q1.getName());
        ClientConsumer consumer2 = session.createConsumer(q2.getName());
        ClientProducer producer = session.createProducer(this.baseAddress);
        int num = 10;
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = session.createMessage((byte)3, true);
            m.getBodyBuffer().writeString("AnyCast" + i);
            producer.send((Message)m);
        }
        Assertions.assertNull((Object)consumer1.receive(200L));
        Assertions.assertNull((Object)consumer2.receive(200L));
        session.commit();
        session.close();
        Assertions.assertTrue((boolean)TimeUtils.waitOnBoolean((boolean)true, (long)2000L, () -> 5L == q1.getMessageCount()));
        Assertions.assertTrue((boolean)TimeUtils.waitOnBoolean((boolean)true, (long)2000L, () -> 5L == q2.getMessageCount()));
        ClientSession session1 = this.sessionFactory.createSession(false, false);
        ClientSession session2 = this.sessionFactory.createSession(false, false);
        session1.start();
        session2.start();
        consumer1 = session1.createConsumer(q1.getName());
        consumer2 = session2.createConsumer(q2.getName());
        ClientConsumer[] consumers = new ClientConsumer[]{consumer1, consumer2};
        ClientSession[] sessions = new ClientSession[]{session1, session2};
        Queue[] queues = new Queue[]{q1, q2};
        for (int i = 0; i < consumers.length; ++i) {
            ClientMessage m;
            int j;
            for (j = 0; j < 5; ++j) {
                m = consumers[i].receive(2000L);
                Assertions.assertNotNull((Object)m);
                logger.debug("consumer{} received: {}", (Object)i, (Object)m.getBodyBuffer().readString());
            }
            Assertions.assertNull((Object)consumers[i].receive(200L));
            sessions[i].rollback();
            sessions[i].close();
            sessions[i] = this.sessionFactory.createSession(false, false);
            sessions[i].start();
            consumers[i] = sessions[i].createConsumer(queues[i].getName());
            for (j = 0; j < 5; ++j) {
                m = consumers[i].receive(2000L);
                Assertions.assertNotNull((Object)m);
                logger.debug("consumer{} received: {}", (Object)i, (Object)m.getBodyBuffer().readString());
            }
            Assertions.assertNull((Object)consumers[i].receive(200L));
            sessions[i].commit();
            Assertions.assertNull((Object)consumers[i].receive(200L));
            sessions[i].close();
        }
        q1.deleteQueue();
        q2.deleteQueue();
    }
}

