/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpReceiverPriorityTest
extends AmqpClientTestSupport {
    @Test
    @Timeout(value=30L)
    public void testPriority() throws Exception {
        AmqpMessage message1;
        int i;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        HashMap<Symbol, Object> properties1 = new HashMap<Symbol, Object>();
        properties1.put(Symbol.getSymbol((String)"priority"), 5);
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName(), null, false, false, properties1);
        receiver1.flow(100);
        HashMap<Symbol, Object> properties2 = new HashMap<Symbol, Object>();
        properties2.put(Symbol.getSymbol((String)"priority"), 50);
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName(), null, false, false, properties2);
        receiver2.flow(100);
        HashMap<Symbol, Object> properties3 = new HashMap<Symbol, Object>();
        properties3.put(Symbol.getSymbol((String)"priority"), 10);
        AmqpReceiver receiver3 = session.createReceiver(this.getQueueName(), null, false, false, properties3);
        receiver3.flow(100);
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message2 = receiver2.receive(250L, TimeUnit.MILLISECONDS);
            AmqpMessage message3 = receiver3.receiveNoWait();
            Assertions.assertNotNull((Object)message2, (String)"did not receive message first time");
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message2.getMessageId());
            message2.accept();
            Assertions.assertNull((Object)message1, (String)"message is not meant to goto lower priority receiver");
            Assertions.assertNull((Object)message3, (String)"message is not meant to goto lower priority receiver");
        }
        this.assertNoMessage(receiver1);
        this.assertNoMessage(receiver3);
        receiver2.close();
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message3 = receiver3.receive(250L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)message3, (String)"did not receive message first time");
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message3.getMessageId());
            message3.accept();
            Assertions.assertNull((Object)message1, (String)"message is not meant to goto lower priority receiver");
        }
        this.assertNoMessage(receiver1);
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testPrioritySetOnAddress() throws Exception {
        AmqpMessage message1;
        int i;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String queueName1 = this.getQueueName() + "?consumer-priority=5";
        AmqpReceiver receiver1 = session.createReceiver(queueName1, null, false, false);
        receiver1.flow(100);
        String queueName2 = this.getQueueName() + "?consumer-priority=50";
        AmqpReceiver receiver2 = session.createReceiver(queueName2, null, false, false);
        receiver2.flow(100);
        String queueName3 = this.getQueueName() + "?consumer-priority=10";
        AmqpReceiver receiver3 = session.createReceiver(queueName3, null, false, false);
        receiver3.flow(100);
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message2 = receiver2.receive(250L, TimeUnit.MILLISECONDS);
            AmqpMessage message3 = receiver3.receiveNoWait();
            Assertions.assertNotNull((Object)message2, (String)"did not receive message first time");
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message2.getMessageId());
            message2.accept();
            Assertions.assertNull((Object)message1, (String)"message is not meant to goto lower priority receiver");
            Assertions.assertNull((Object)message3, (String)"message is not meant to goto lower priority receiver");
        }
        this.assertNoMessage(receiver1);
        this.assertNoMessage(receiver3);
        receiver2.close();
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message3 = receiver3.receive(250L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)message3, (String)"did not receive message first time");
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message3.getMessageId());
            message3.accept();
            Assertions.assertNull((Object)message1, (String)"message is not meant to goto lower priority receiver");
        }
        this.assertNoMessage(receiver1);
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testAttachPropertiesPriorityTakesPrecedenceOverAddress() throws Exception {
        AmqpMessage message1;
        int i;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        HashMap<Symbol, Object> properties1 = new HashMap<Symbol, Object>();
        properties1.put(Symbol.getSymbol((String)"priority"), 5);
        String queueName1 = this.getQueueName() + "?consumer-priority=50";
        AmqpReceiver receiver1 = session.createReceiver(queueName1, null, false, false, properties1);
        receiver1.flow(100);
        HashMap<Symbol, Object> properties2 = new HashMap<Symbol, Object>();
        properties2.put(Symbol.getSymbol((String)"priority"), 50);
        String queueName2 = this.getQueueName() + "?consumer-priority=10&ingored-parameter=false";
        AmqpReceiver receiver2 = session.createReceiver(queueName2, null, false, false, properties2);
        receiver2.flow(100);
        HashMap<Symbol, Object> properties3 = new HashMap<Symbol, Object>();
        properties3.put(Symbol.getSymbol((String)"priority"), 10);
        String queueName3 = this.getQueueName() + "?consumer-priority=5";
        AmqpReceiver receiver3 = session.createReceiver(queueName3, null, false, false, properties3);
        receiver3.flow(100);
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message2 = receiver2.receive(250L, TimeUnit.MILLISECONDS);
            AmqpMessage message3 = receiver3.receiveNoWait();
            Assertions.assertNotNull((Object)message2, (String)"did not receive message first time");
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message2.getMessageId());
            message2.accept();
            Assertions.assertNull((Object)message1, (String)"message is not meant to goto lower priority receiver");
            Assertions.assertNull((Object)message3, (String)"message is not meant to goto lower priority receiver");
        }
        this.assertNoMessage(receiver1);
        this.assertNoMessage(receiver3);
        receiver2.close();
        this.sendMessages(this.getQueueName(), 5);
        for (i = 0; i < 5; ++i) {
            message1 = receiver1.receiveNoWait();
            AmqpMessage message3 = receiver3.receive(250L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)message3, (String)"did not receive message first time");
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message3.getMessageId());
            message3.accept();
            Assertions.assertNull((Object)message1, (String)"message is not meant to goto lower priority receiver");
        }
        this.assertNoMessage(receiver1);
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testBadValueInPriorityPropertyOnAddress() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String queueName1 = this.getQueueName() + "?consumer-priority=test";
        try {
            session.createReceiver(queueName1, null, false, false);
            Assertions.fail((String)"Should fail to create as query string is malformed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    public void assertNoMessage(AmqpReceiver receiver) throws Exception {
        AmqpMessage message = receiver.receive(250L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)message, (String)"message is not meant to goto lower priority receiver");
    }

    @Test
    @Timeout(value=30L)
    public void testPriorityProvidedAsByte() throws Exception {
        this.testPriorityNumber((byte)5);
    }

    @Test
    @Timeout(value=30L)
    public void testPriorityProvidedAsUnsignedInteger() throws Exception {
        this.testPriorityNumber((Number)UnsignedInteger.valueOf((int)5));
    }

    private void testPriorityNumber(Number number) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        HashMap<Symbol, Object> properties1 = new HashMap<Symbol, Object>();
        properties1.put(Symbol.getSymbol((String)"priority"), number);
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName(), null, false, false, properties1);
        receiver1.flow(100);
        this.sendMessages(this.getQueueName(), 2);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage message1 = receiver1.receive(3000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)message1, (String)("did not receive message" + i));
            Assertions.assertEquals((Object)("MessageID:" + i), (Object)message1.getMessageId());
            message1.accept();
        }
        connection.close();
    }
}

