/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSessionTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testCreateSession() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSessionClosedDoesNotGetReceiverDetachFromRemote() throws Exception {
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectClosedResource(Session session) {
                logger.debug("Session closed: {}", session.getContext());
            }

            @Override
            public void inspectDetachedResource(Receiver receiver) {
                this.markAsInvalid("Broker should not detach receiver linked to closed session.");
            }

            @Override
            public void inspectClosedResource(Receiver receiver) {
                this.markAsInvalid("Broker should not close receiver linked to closed session.");
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        Assertions.assertNotNull((Object)connection);
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Assertions.assertNotNull((Object)receiver);
        session.close();
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateSessionProducerConsumerDoesNotLeakClosable() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        for (int i = 0; i < 10; ++i) {
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            AmqpSender sender = session.createSender(this.getQueueName());
            receiver.close();
            sender.close();
        }
        Assertions.assertEquals((int)1, (int)this.server.getSessions().size());
        for (ServerSession serverSession : this.server.getSessions()) {
            Assertions.assertNull((Object)((ServerSessionImpl)serverSession).getCloseables());
        }
        connection.close();
    }
}

