/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptedAMQPLargeMessage
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NUMBER_OF_THREADS = 10;
    private static final int MINIMAL_SEND = 2;
    private static final int MESSAGE_SIZE = 307200;
    private static final String smallFrameAcceptor = new String("tcp://localhost:5680");

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("flow", smallFrameAcceptor + "?protocols=AMQP;useEpoll=false;maxFrameSize=512;amqpMinLargeMessageSize=10000");
    }

    public static void main(String[] arg) {
        CyclicBarrier startFlag = new CyclicBarrier(10);
        CountDownLatch minimalKill = new CountDownLatch(20);
        Runnable runnable = () -> {
            try {
                AmqpClient client = InterruptedAMQPLargeMessage.createLocalClient();
                AmqpConnection connection = client.createConnection();
                connection.setMaxFrameSize(2048);
                connection.connect();
                AmqpSession session = connection.createSession();
                AmqpSender sender = session.createSender(arg[0]);
                startFlag.await();
                for (int m = 0; m < 1000; ++m) {
                    AmqpMessage message = new AmqpMessage();
                    message.setDurable(true);
                    byte[] bytes = new byte[307200];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = 122;
                    }
                    message.setBytes(bytes);
                    sender.send(message);
                    minimalKill.countDown();
                }
                connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        for (int t = 0; t < 10; ++t) {
            Thread thread = new Thread(runnable);
            thread.start();
        }
        try {
            minimalKill.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    private static AmqpClient createLocalClient() throws URISyntaxException {
        return new AmqpClient(new URI(smallFrameAcceptor), null, null);
    }

    @Test
    public void testInterruptedLargeMessage() throws Exception {
        Process p = SpawnedVMSupport.spawnVM((String)InterruptedAMQPLargeMessage.class.getName(), (String[])new String[]{this.getQueueName()});
        p.waitFor();
        Queue serverQueue = this.server.locateQueue(this.getQueueName());
        Assertions.assertTrue((serverQueue.getMessageCount() >= 20L ? 1 : 0) != 0);
        LinkedListIterator browserIterator = serverQueue.browserIterator();
        while (browserIterator.hasNext()) {
            MessageReference ref = (MessageReference)browserIterator.next();
            Message message = ref.getMessage();
            Assertions.assertNotNull((Object)message);
            Assertions.assertTrue((boolean)(message instanceof LargeServerMessage));
        }
        browserIterator.close();
        logger.debug("There are {} on the queue", (Object)serverQueue.getMessageCount());
        int messageCount = (int)serverQueue.getMessageCount();
        AmqpClient client = InterruptedAMQPLargeMessage.createLocalClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setMaxFrameSize(2048);
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        int received = 0;
        receiver.flow(messageCount + 10);
        for (int m = 0; m < messageCount; ++m) {
            receiver.flow(1);
            AmqpMessage message = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            message.accept(true);
            logger.debug("Received {}", (Object)(++received));
            Data data = (Data)message.getWrappedMessage().getBody();
            byte[] byteArray = data.getValue().getArray();
            Assertions.assertEquals((int)307200, (int)byteArray.length);
            for (int i = 0; i < byteArray.length; ++i) {
                Assertions.assertEquals((byte)122, (byte)byteArray[i]);
            }
        }
        Assertions.assertNull((Object)receiver.receiveNoWait());
        this.validateNoFilesOnLargeDir();
    }
}

