/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.lockmanager;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LockManagerExtraBackupReplicatedFailoverTest
extends FailoverTestBase {
    private static final String GROUP_NAME = "foo";
    @Parameter(index=0)
    public boolean useGroupName;

    @Parameters(name="useGroupName={0}")
    public static Iterable<Object[]> getParams() {
        return Arrays.asList({false}, {true});
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        if (this.useGroupName) {
            ((ReplicationPrimaryPolicyConfiguration)this.primaryConfig.getHAPolicyConfiguration()).setGroupName(GROUP_NAME);
            ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setGroupName(GROUP_NAME);
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @TestTemplate
    public void testExtraBackupReplicates() throws Exception {
        Configuration secondBackupConfig = this.backupConfig.copy();
        String secondBackupGroupName = ((ReplicationBackupPolicyConfiguration)secondBackupConfig.getHAPolicyConfiguration()).getGroupName();
        Assertions.assertEquals((Object)((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).getGroupName(), (Object)secondBackupGroupName);
        if (this.useGroupName) {
            Assertions.assertEquals((Object)GROUP_NAME, (Object)secondBackupGroupName);
        } else {
            Assertions.assertNull((Object)secondBackupGroupName);
        }
        TestableServer secondBackupServer = this.createTestableServer(secondBackupConfig);
        secondBackupConfig.setBindingsDirectory(this.getBindingsDir(1, true)).setJournalDirectory(this.getJournalDir(1, true)).setPagingDirectory(this.getPageDir(1, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(1, true)).setSecurityEnabled(false);
        LockManagerExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization(this.backupServer.getServer());
        secondBackupServer.start();
        Thread.sleep(5000L);
        this.backupServer.stop();
        this.waitForSync(secondBackupServer.getServer());
        LockManagerExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization(secondBackupServer.getServer());
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }
}

