/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.consumer;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectOrphanedConsumerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testOrphanedConsumerCORE() throws Exception {
        this.testOrphanedConsumer("CORE");
    }

    @Test
    public void testOrphanedConsumerAMQP() throws Exception {
        this.testOrphanedConsumer("AMQP");
    }

    @Test
    public void testOrphanedConsumerOpenWire() throws Exception {
        this.testOrphanedConsumer("OPENWIRE");
    }

    private void testOrphanedConsumer(String protocol) throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultConfig(true));
        server.start();
        Queue queue = server.createQueue(QueueConfiguration.of((String)this.getName()).setDurable(Boolean.valueOf(true)).setName(this.getName()).setRoutingType(RoutingType.ANYCAST));
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        this.runAfter(() -> ((Connection)connection).close());
        Session session = connection.createSession(false, 1);
        MessageConsumer willBeOrphaned = session.createConsumer((Destination)session.createQueue(this.getName()));
        Wait.assertEquals((int)1, () -> ((Queue)queue).getConsumerCount(), (long)5000L);
        QueueControl queueControl = (QueueControl)server.getManagementService().getResource("queue." + queue.getName().toString());
        Assertions.assertNotNull((Object)queueControl);
        String result = queueControl.listConsumersAsJSON();
        logger.debug("json: {}", (Object)result);
        JsonArray resultArray = JsonUtil.readJsonArray((String)result);
        Assertions.assertEquals((int)1, (int)resultArray.size());
        Assertions.assertEquals((Object)"OK", (Object)resultArray.getJsonObject(0).getString(ConsumerField.STATUS.getName()));
        queue.getConsumers().forEach(c -> {
            ServerConsumerImpl serverConsumer = (ServerConsumerImpl)c;
            logger.debug("Removing connection for {} on connectionID {}", (Object)serverConsumer, serverConsumer.getConnectionID());
            RemotingConnection removed = server.getRemotingService().removeConnection(serverConsumer.getConnectionID());
            logger.debug("removed {}", (Object)removed);
        });
        result = queueControl.listConsumersAsJSON();
        logger.debug("json: {}", (Object)result);
        resultArray = JsonUtil.readJsonArray((String)result);
        Assertions.assertEquals((int)1, (int)resultArray.size());
        Assertions.assertEquals((Object)"Orphaned", (Object)resultArray.getJsonObject(0).getString(ConsumerField.STATUS.getName()));
        ActiveMQServerControl serverControl = (ActiveMQServerControl)server.getManagementService().getResource("broker");
        String sessionID = resultArray.getJsonObject(0).getString(ConsumerField.SESSION.getAlternativeName());
        int consumerID = resultArray.getJsonObject(0).getInt(ConsumerField.SEQUENTIAL_ID.getAlternativeName());
        logger.debug("SessionID{} ConsumerID::{}", (Object)sessionID, (Object)consumerID);
        Assertions.assertTrue((boolean)serverControl.closeConsumerWithID(sessionID, String.valueOf(consumerID)));
    }
}

