/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JMSSecurityTest
extends JMSTestBase {
    private static final String GOOD_USER = "IDo";
    private static final String GOOD_PASSWORD = "Exist";
    private static final String BAD_USER = "Idont";
    private static final String BAD_PASSWORD = "exist";

    @Override
    public boolean useSecurity() {
        return true;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testSecurityOnJMSContext() throws Exception {
        JMSContext ctx2;
        this.addUserToSecurityManager();
        try {
            ctx2 = this.cf.createContext(BAD_USER, BAD_PASSWORD);
            ctx2.close();
        }
        catch (JMSSecurityRuntimeException ctx2) {
            // empty catch block
        }
        try {
            ctx2 = this.cf.createContext(BAD_USER, GOOD_PASSWORD);
            ctx2.close();
        }
        catch (JMSSecurityRuntimeException ctx3) {
            // empty catch block
        }
        try {
            ctx2 = this.cf.createContext(GOOD_USER, BAD_PASSWORD);
            ctx2.close();
        }
        catch (JMSSecurityRuntimeException ctx4) {
            // empty catch block
        }
        ctx2 = this.cf.createContext(GOOD_USER, GOOD_PASSWORD);
        ctx2.close();
    }

    @Test
    public void testCreateQueueConnection() throws Exception {
        QueueConnection queueC2;
        this.addUserToSecurityManager();
        try {
            queueC2 = ((QueueConnectionFactory)this.cf).createQueueConnection(BAD_USER, BAD_PASSWORD);
            Assertions.fail((String)"supposed to throw exception");
            queueC2.close();
        }
        catch (JMSSecurityException queueC2) {
            // empty catch block
        }
        try {
            queueC2 = ((QueueConnectionFactory)this.cf).createQueueConnection(BAD_USER, GOOD_PASSWORD);
            Assertions.fail((String)"supposed to throw exception");
            queueC2.close();
        }
        catch (JMSSecurityException queueC3) {
            // empty catch block
        }
        try {
            queueC2 = ((QueueConnectionFactory)this.cf).createQueueConnection(GOOD_USER, BAD_PASSWORD);
            Assertions.fail((String)"supposed to throw exception");
            queueC2.close();
        }
        catch (JMSSecurityException queueC4) {
            // empty catch block
        }
        queueC2 = ((QueueConnectionFactory)this.cf).createQueueConnection(GOOD_USER, GOOD_PASSWORD);
        queueC2.close();
    }

    @Test
    public void testMaskedPasswordOnJMSContext() throws Exception {
        JMSContext ctx2;
        String maskedPassword = PasswordMaskingUtil.getDefaultCodec().encode((Object)GOOD_PASSWORD);
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager();
        try {
            ctx2 = this.cf.createContext(BAD_USER, wrappedPassword);
            ctx2.close();
        }
        catch (JMSSecurityRuntimeException ctx2) {
            // empty catch block
        }
        ctx2 = this.cf.createContext(GOOD_USER, wrappedPassword);
        ctx2.close();
    }

    @Test
    public void testMaskedPasswordCreateQueueConnection() throws Exception {
        QueueConnection queueC2;
        String maskedPassword = PasswordMaskingUtil.getDefaultCodec().encode((Object)GOOD_PASSWORD);
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager();
        try {
            queueC2 = ((QueueConnectionFactory)this.cf).createQueueConnection(BAD_USER, wrappedPassword);
            Assertions.fail((String)"supposed to throw exception");
            queueC2.close();
        }
        catch (JMSSecurityException queueC2) {
            // empty catch block
        }
        queueC2 = ((QueueConnectionFactory)this.cf).createQueueConnection(GOOD_USER, wrappedPassword);
        queueC2.close();
    }

    @Test
    public void testMaskedPasswordURL() throws Exception {
        ActiveMQConnectionFactory testCF2;
        String maskedPassword = PasswordMaskingUtil.getDefaultCodec().encode((Object)GOOD_PASSWORD);
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager();
        String brokerURL = "tcp://localhost:61616";
        try {
            testCF2 = new ActiveMQConnectionFactory(brokerURL);
            try {
                testCF2.setUser(BAD_USER).setPassword(wrappedPassword);
                Connection conn = testCF2.createConnection();
                Assertions.fail((String)"supposed to throw exception");
                conn.close();
            }
            finally {
                testCF2.close();
            }
        }
        catch (JMSSecurityException testCF2) {
            // empty catch block
        }
        testCF2 = new ActiveMQConnectionFactory(brokerURL);
        try {
            testCF2.setUser(GOOD_USER).setPassword(wrappedPassword);
            JMSContext ctx = testCF2.createContext();
            ctx.close();
        }
        finally {
            testCF2.close();
        }
    }

    @Test
    public void testMaskedPasswordURLUsernamePassword() throws Exception {
        ActiveMQConnectionFactory testCF2;
        String maskedPassword = PasswordMaskingUtil.getDefaultCodec().encode((Object)GOOD_PASSWORD);
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager();
        try {
            testCF2 = new ActiveMQConnectionFactory("tcp://localhost:61616", BAD_USER, wrappedPassword);
            try {
                Connection conn = testCF2.createConnection();
                Assertions.fail((String)"supposed to throw exception");
                conn.close();
            }
            finally {
                testCF2.close();
            }
        }
        catch (JMSSecurityException testCF2) {
            // empty catch block
        }
        testCF2 = new ActiveMQConnectionFactory("tcp://localhost:61616", GOOD_USER, wrappedPassword);
        try {
            JMSContext ctx = testCF2.createContext();
            ctx.close();
        }
        finally {
            testCF2.close();
        }
    }

    @Test
    public void testMaskedPasswordCodec() throws Exception {
        ActiveMQConnectionFactory testCF2;
        String maskedPassword = "supersecureish";
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager(GOOD_USER, "securepass");
        try {
            testCF2 = new ActiveMQConnectionFactory();
            try {
                testCF2.setUser(BAD_USER).setPassword(wrappedPassword).setPasswordCodec(JMSSecurityTestPasswordCodec.class.getName());
                Connection conn = testCF2.createConnection();
                Assertions.fail((String)"supposed to throw exception");
                conn.close();
            }
            finally {
                testCF2.close();
            }
        }
        catch (JMSSecurityException testCF2) {
            // empty catch block
        }
        testCF2 = new ActiveMQConnectionFactory();
        try {
            testCF2.setUser(GOOD_USER).setPassword(wrappedPassword).setPasswordCodec(JMSSecurityTestPasswordCodec.class.getName());
            JMSContext ctx = testCF2.createContext();
            ctx.close();
        }
        finally {
            testCF2.close();
        }
    }

    @Test
    public void testMaskedPasswordCodecURL() throws Exception {
        ActiveMQConnectionFactory testCF2;
        String maskedPassword = "supersecureish";
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager(GOOD_USER, "securepass");
        String brokerURL = "tcp://localhost:61616?passwordCodec=" + JMSSecurityTestPasswordCodec.class.getName();
        try {
            testCF2 = new ActiveMQConnectionFactory(brokerURL);
            try {
                testCF2.setUser(BAD_USER).setPassword(wrappedPassword);
                Connection conn = testCF2.createConnection();
                Assertions.fail((String)"supposed to throw exception");
                conn.close();
            }
            finally {
                testCF2.close();
            }
        }
        catch (JMSSecurityException testCF2) {
            // empty catch block
        }
        testCF2 = new ActiveMQConnectionFactory(brokerURL);
        try {
            testCF2.setUser(GOOD_USER).setPassword(wrappedPassword);
            JMSContext ctx = testCF2.createContext();
            ctx.close();
        }
        finally {
            testCF2.close();
        }
    }

    @Test
    public void testMaskedPasswordCodecURLUsernamePassword() throws Exception {
        ActiveMQConnectionFactory testCF2;
        String maskedPassword = "supersecureish";
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager(GOOD_USER, "securepass");
        String brokerURL = "tcp://localhost:61616?passwordCodec=" + JMSSecurityTestPasswordCodec.class.getName();
        try {
            testCF2 = new ActiveMQConnectionFactory(brokerURL, BAD_USER, wrappedPassword);
            try {
                Connection conn = testCF2.createConnection();
                Assertions.fail((String)"supposed to throw exception");
                conn.close();
            }
            finally {
                testCF2.close();
            }
        }
        catch (JMSSecurityException testCF2) {
            // empty catch block
        }
        testCF2 = new ActiveMQConnectionFactory(brokerURL, GOOD_USER, wrappedPassword);
        try {
            JMSContext ctx = testCF2.createContext();
            ctx.close();
        }
        finally {
            testCF2.close();
        }
    }

    @Test
    public void testBadMaskedPasswordCodecURL() throws Exception {
        String maskedPassword = "supersecureishThisIsDesignedToFail";
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager(GOOD_USER, "securepass");
        String brokerURL = "tcp://localhost:61616?passwordCodec=" + JMSSecurityTestPasswordCodec.class.getName();
        try (ActiveMQConnectionFactory testCF = new ActiveMQConnectionFactory(brokerURL);){
            testCF.setUser(GOOD_USER).setPassword(wrappedPassword);
            Connection conn = testCF.createConnection();
            Assertions.fail((String)"supposed to throw exception");
            conn.close();
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }

    @Test
    public void testBadMaskedPasswordCodecURLUsernamePassword() throws Exception {
        String maskedPassword = "supersecureishThisIsDesignedToFail";
        String wrappedPassword = PasswordMaskingUtil.wrap((String)maskedPassword);
        this.addUserToSecurityManager(GOOD_USER, "securepass");
        String brokerURL = "tcp://localhost:61616?passwordCodec=" + JMSSecurityTestPasswordCodec.class.getName();
        try (ActiveMQConnectionFactory testCF = new ActiveMQConnectionFactory(brokerURL, GOOD_USER, wrappedPassword);){
            Connection conn = testCF.createConnection();
            Assertions.fail((String)"supposed to throw exception");
            conn.close();
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }

    private void addUserToSecurityManager() {
        this.addUserToSecurityManager(GOOD_USER, GOOD_PASSWORD);
    }

    private void addUserToSecurityManager(String user, String password) {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser(user, password);
    }

    public static class JMSSecurityTestPasswordCodec
    implements SensitiveDataCodec<String> {
        private static final String MASK = "supersecureish";
        private static final String CLEARTEXT = "securepass";

        public String decode(Object mask) throws Exception {
            if (!MASK.equals(mask)) {
                return mask.toString();
            }
            return CLEARTEXT;
        }

        public String encode(Object secret) throws Exception {
            if (!CLEARTEXT.equals(secret)) {
                return secret.toString();
            }
            return MASK;
        }
    }
}

