/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExclusiveTest
extends JMSTestBase {
    private SimpleString queueName = SimpleString.of((String)"jms.exclusive.queue");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusiveQueueConsumer() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            int j;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 100; ++j) {
                TextMessage tm = (TextMessage)consumer1.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                Assertions.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusiveWithJMS2Producer() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (JMSContext ctx = this.addContext(this.getCF().createContext(0));){
            int j;
            JMSProducer producer = ctx.createProducer();
            Queue queue = ctx.createQueue(this.queueName.toString());
            JMSConsumer consumer1 = ctx.createConsumer((Destination)queue);
            JMSConsumer consumer2 = ctx.createConsumer((Destination)queue);
            JMSConsumer consumer3 = ctx.createConsumer((Destination)queue);
            ctx.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = ctx.createTextMessage("Message" + j);
                producer.send((Destination)queue, (Message)message);
            }
            ctx.commit();
            for (j = 0; j < 100; ++j) {
                TextMessage tm = (TextMessage)consumer1.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                tm.acknowledge();
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                Assertions.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
            ctx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusiveQueueConsumerSettingUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            int j;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue("random?exclusive=true");
            Assertions.assertEquals((Object)"random", (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            Assertions.assertTrue((boolean)a.getQueueAttributes().getExclusive());
            Assertions.assertTrue((boolean)a.getQueueConfiguration().isExclusive());
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 100; ++j) {
                TextMessage tm = (TextMessage)consumer1.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                Assertions.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusiveQueueConsumerFailover() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            TextMessage tm;
            int j;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 50; ++j) {
                tm = (TextMessage)consumer1.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                Assertions.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
            consumer1.close();
            for (j = 50; j < 100; ++j) {
                tm = (TextMessage)consumer2.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusiveTopicSharedConsumerFailover() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            TextMessage tm;
            int j;
            Session session = connection.createSession(false, 2);
            Topic topic = session.createTopic("mytopic");
            MessageProducer producer = session.createProducer((Destination)topic);
            String subscriptionName = "sharedsub";
            Topic topicConsumer = session.createTopic("mytopic?exclusive=true");
            MessageConsumer consumer1 = session.createSharedDurableConsumer(topicConsumer, subscriptionName);
            MessageConsumer consumer2 = session.createSharedDurableConsumer(topicConsumer, subscriptionName);
            MessageConsumer consumer3 = session.createSharedDurableConsumer(topicConsumer, subscriptionName);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 50; ++j) {
                tm = (TextMessage)consumer1.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                Assertions.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
            consumer1.close();
            for (j = 50; j < 100; ++j) {
                tm = (TextMessage)consumer2.receive(10000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer3.receiveNoWait();
                Assertions.assertNull((Object)tm);
            }
        }
    }
}

