/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessagePropertiesTest
extends MultiprotocolJMSClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesAMQPProducerCoreConsumer() throws Exception {
        this.testMessageProperties(this.createConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesAMQPProducerAMQPConsumer() throws Exception {
        this.testMessageProperties(this.createConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesAMQPProducerOpenWireConsumer() throws Exception {
        this.testMessageProperties(this.createConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesCoreProducerAMQPConsumer() throws Exception {
        this.testMessageProperties(this.createCoreConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesCoreProducerCoreConsumer() throws Exception {
        this.testMessageProperties(this.createCoreConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesCoreProducerOpenWireConsumer() throws Exception {
        this.testMessageProperties(this.createCoreConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesOpenWireProducerAMQPConsumer() throws Exception {
        this.testMessageProperties(this.createOpenWireConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesOpenWireProducerCoreConsumer() throws Exception {
        this.testMessageProperties(this.createOpenWireConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=30L)
    public void testMessagePropertiesOpenWireProducerOpenWireConsumer() throws Exception {
        this.testMessageProperties(this.createOpenWireConnection(), this.createOpenWireConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageProperties(Connection producerConnection, Connection consumerConnection) throws JMSException {
        String stringPropertyName = "myStringProperty";
        String stringPropertyValue = RandomUtil.randomString();
        String intPropertyName = "myIntProperty";
        int intPropertyValue = RandomUtil.randomInt();
        String longPropertyName = "myLongProperty";
        long longPropertyValue = RandomUtil.randomLong();
        String shortPropertyName = "myShortProperty";
        short shortPropertyValue = RandomUtil.randomShort();
        String doublePropertyName = "myDoubleProperty";
        double doublePropertyValue = RandomUtil.randomDouble();
        String floatPropertyName = "myFloatProperty";
        float floatPropertyValue = RandomUtil.randomFloat();
        String bytePropertyName = "myByteProperty";
        byte bytePropertyValue = RandomUtil.randomByte();
        String booleanPropertyName = "myBooleanProperty";
        boolean booleanPropertyValue = RandomUtil.randomBoolean();
        try {
            Session producerSession = producerConnection.createSession(false, 1);
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue(this.getQueueName()));
            MessageProducer producer = producerSession.createProducer((Destination)producerSession.createQueue(this.getQueueName()));
            producerConnection.start();
            Message message = producerSession.createMessage();
            message.setStringProperty("myStringProperty", stringPropertyValue);
            message.setIntProperty("myIntProperty", intPropertyValue);
            message.setLongProperty("myLongProperty", longPropertyValue);
            message.setShortProperty("myShortProperty", shortPropertyValue);
            message.setDoubleProperty("myDoubleProperty", doublePropertyValue);
            message.setFloatProperty("myFloatProperty", floatPropertyValue);
            message.setByteProperty("myByteProperty", bytePropertyValue);
            message.setBooleanProperty("myBooleanProperty", booleanPropertyValue);
            producer.send(message);
            Message received = consumer.receive(100L);
            Assertions.assertNotNull((Object)received, (String)"Should have received a message by now.");
            Assertions.assertEquals((Object)stringPropertyValue, (Object)received.getStringProperty("myStringProperty"));
            Assertions.assertEquals((int)intPropertyValue, (int)received.getIntProperty("myIntProperty"));
            Assertions.assertEquals((long)longPropertyValue, (long)received.getLongProperty("myLongProperty"));
            Assertions.assertEquals((short)shortPropertyValue, (short)received.getShortProperty("myShortProperty"));
            Assertions.assertEquals((double)doublePropertyValue, (double)received.getDoubleProperty("myDoubleProperty"), (double)0.0);
            Assertions.assertEquals((double)floatPropertyValue, (double)received.getFloatProperty("myFloatProperty"), (double)0.0);
            Assertions.assertEquals((byte)bytePropertyValue, (byte)received.getByteProperty("myByteProperty"));
            Assertions.assertEquals((Object)booleanPropertyValue, (Object)received.getBooleanProperty("myBooleanProperty"));
        }
        finally {
            producerConnection.close();
            consumerConnection.close();
        }
    }
}

