/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server.management;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicControlClusterTest
extends JMSClusteredTestBase {
    @Test
    public void testClusteredSubscriptionCount() throws Exception {
        String topicName = "t1";
        SimpleString simpleTopicName = SimpleString.of((String)"t1");
        try (Connection conn1 = this.cf1.createConnection();
             Connection conn2 = this.cf2.createConnection();){
            conn1.setClientID("someClient1");
            conn2.setClientID("someClient2");
            Topic topic1 = this.createTopic("t1");
            Topic topic2 = (Topic)this.context2.lookup("/topic/t1");
            Session session1 = conn1.createSession(false, 1);
            session1.createDurableSubscriber(topic1, "sub1_1");
            session1.createDurableSubscriber(topic1, "sub1_2");
            Session session2 = conn2.createSession(false, 1);
            session2.createDurableSubscriber(topic2, "sub2");
            AddressControl topicControl1 = ManagementControlHelper.createAddressControl(simpleTopicName, this.mBeanServer1);
            AddressControl topicControl2 = ManagementControlHelper.createAddressControl(simpleTopicName, this.mBeanServer2);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> topicControl1.getQueueNames().length == 2, (long)2000L), (String)"There should be 2 local subscriptions on the topic.");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> topicControl1.getRemoteQueueNames().length == 1, (long)2000L), (String)"There should be 1 remote subscription on the topic.");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> topicControl2.getQueueNames().length == 1, (long)2000L), (String)"There should be 1 local subscription on the topic.");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> topicControl2.getRemoteQueueNames().length == 2, (long)2000L), (String)"There should be 2 remote subscriptions on the topic.");
        }
        this.jmsServer1.destroyTopic("t1");
        this.jmsServer2.destroyTopic("t1");
    }
}

