/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.management.impl.ManagementServiceImpl;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.tests.integration.server.FakeStorageManager;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.fakes.FakeQueue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagementServiceImplTest
extends ActiveMQTestBase {
    @Test
    public void testHandleManagementMessageWithOperation() throws Exception {
        String queue = RandomUtil.randomString();
        String address = RandomUtil.randomString();
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"createQueue", (Object[])new Object[]{queue, address});
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertTrue((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
    }

    @Test
    public void testHandleManagementMessageWithOperationWhichFails() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"thereIsNoSuchOperation");
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertFalse((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
        Assertions.assertNotNull((Object)ManagementHelper.getResult((ICoreMessage)reply));
    }

    @Test
    public void testHandleManagementMessageWithUnknowResource() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"Resouce.Does.Not.Exist", (String)"toString");
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertFalse((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
        Assertions.assertNotNull((Object)ManagementHelper.getResult((ICoreMessage)reply));
    }

    @Test
    public void testHandleManagementMessageWithUnknownAttribute() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        ManagementHelper.putAttribute((ICoreMessage)message, (String)"broker", (String)"started");
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertTrue((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
        Assertions.assertTrue((boolean)((Boolean)ManagementHelper.getResult((ICoreMessage)reply)));
    }

    @Test
    public void testHandleManagementMessageWithKnownAttribute() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        ManagementHelper.putAttribute((ICoreMessage)message, (String)"broker", (String)"attribute.Does.Not.Exist");
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertFalse((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
        Assertions.assertNotNull((Object)ManagementHelper.getResult((ICoreMessage)reply));
    }

    @Test
    public void testGetResources() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ManagementServiceImpl managementService = new ManagementServiceImpl(null, (Configuration)config);
        managementService.setStorageManager((StorageManager)new NullStorageManager());
        SimpleString address = RandomUtil.randomSimpleString();
        managementService.registerAddress(new AddressInfo(address));
        FakeQueue queue = new FakeQueue(RandomUtil.randomSimpleString());
        managementService.registerQueue((Queue)queue, RandomUtil.randomSimpleString(), (StorageManager)new FakeStorageManager());
        Object[] addresses = managementService.getResources(AddressControl.class);
        Assertions.assertEquals((int)1, (int)addresses.length);
        Assertions.assertTrue((boolean)(addresses[0] instanceof AddressControl));
        AddressControl addressControl = (AddressControl)addresses[0];
        Assertions.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        Object[] queues = managementService.getResources(QueueControl.class);
        Assertions.assertEquals((int)1, (int)queues.length);
        Assertions.assertTrue((boolean)(queues[0] instanceof QueueControl));
        QueueControl queueControl = (QueueControl)queues[0];
        Assertions.assertEquals((Object)queue.getName().toString(), (Object)queueControl.getName());
    }

    @Test
    public void testCorrelateResponseByCorrelationID() throws Exception {
        String queue = RandomUtil.randomString();
        String address = RandomUtil.randomString();
        String correlationID = UUIDGenerator.getInstance().generateStringUUID();
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        MessageUtil.setJMSCorrelationID((Message)message, (String)correlationID);
        ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"createQueue", (Object[])new Object[]{queue, address});
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertTrue((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
        Assertions.assertEquals((Object)correlationID, (Object)MessageUtil.getJMSCorrelationID((Message)reply));
    }

    @Test
    public void testCorrelateResponseByMessageID() throws Exception {
        String queue = RandomUtil.randomString();
        String address = RandomUtil.randomString();
        UUID messageId = UUIDGenerator.getInstance().generateUUID();
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        CoreMessage message = new CoreMessage(1L, 100);
        message.setUserID(messageId);
        ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"createQueue", (Object[])new Object[]{queue, address});
        ICoreMessage reply = server.getManagementService().handleMessage(null, (Message)message);
        Assertions.assertTrue((boolean)ManagementHelper.hasOperationSucceeded((Message)reply));
        Assertions.assertEquals((Object)messageId.toString(), (Object)MessageUtil.getJMSCorrelationID((Message)reply));
    }
}

