/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.EOFException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.ProtocolException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.management.impl.view.ProducerField;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.client.Tracer;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PUBLISH;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTTest
extends MQTTTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String AMQP_URI = "tcp://localhost:61616";

    @Override
    public void configureBroker() throws Exception {
        super.configureBroker();
        this.server.getConfiguration().setAddressQueueScanPeriod(100L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithLargePassword() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            String longString = new String(new char[65535]);
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(longString);
                mqtt.setPassword(longString);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                BlockingConnection finalConnection = connection;
                Assertions.assertTrue((boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveMQTT() throws Exception {
        this.testSendAndReceiveMQTT("");
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveMQTTHugePayload() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        while (builder.length() < 112640) {
            builder.append("huge payload huge payload huge payload huge payload ");
        }
        this.testSendAndReceiveMQTT(builder.toString());
    }

    public void testSendAndReceiveMQTT(String extraPayload) throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah", 0);
        CountDownLatch latch = new CountDownLatch(250);
        Thread thread = new Thread(() -> {
            for (int i = 0; i < 250; ++i) {
                try {
                    byte[] payload = subscriptionProvider.receive(10000);
                    Assertions.assertNotNull((Object)payload, (String)"Should get a message");
                    latch.countDown();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i + extraPayload;
            publishProvider.publish("foo/bah", payload.getBytes(), 1);
        }
        latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
    }

    @Test
    public void testProducerMetrics() throws Exception {
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            publishProvider.publish("foo/bah", payload.getBytes(), 1);
        }
        String filterString = this.createJsonFilter("", "", "");
        String producersAsJsonString = this.server.getActiveMQServerControl().listProducers(filterString, 1, 50);
        JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
        JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of producers returned from query");
        JsonObject producer = array.getJsonObject(0);
        Assertions.assertNotEquals((Object)"", (Object)producer.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
        Assertions.assertNotEquals((Object)"", (Object)producer.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
        Assertions.assertNotEquals((Object)"", (Object)producer.getString(ProducerField.CLIENT_ID.getName()), (String)ProducerField.CLIENT_ID.getName());
        Assertions.assertEquals((Object)"", (Object)producer.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
        Assertions.assertEquals((Object)"MQTT", (Object)producer.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getAlternativeName());
        Assertions.assertEquals((Object)"ANONYMOUS", (Object)producer.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
        Assertions.assertNotEquals((Object)"", (Object)producer.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
        Assertions.assertNotEquals((Object)"", (Object)producer.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
        Assertions.assertNotEquals((Object)"", (Object)producer.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
        Assertions.assertEquals((int)250, (int)producer.getInt(ProducerField.MESSAGE_SENT.getName()), (String)ProducerField.MESSAGE_SENT.getName());
        Assertions.assertEquals((Object)"", (Object)producer.getString(ProducerField.LAST_PRODUCED_MESSAGE_ID.getName()), (String)ProducerField.LAST_PRODUCED_MESSAGE_ID.getName());
        MQTTClientProvider publishProvider2 = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            publishProvider2.publish("foo/bah", payload.getBytes(), 1);
        }
        filterString = this.createJsonFilter("", "", "");
        producersAsJsonString = this.server.getActiveMQServerControl().listProducers(filterString, 1, 50);
        producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
        array = (JsonArray)producersAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)2, (int)array.size(), (String)"number of producers returned from query");
        publishProvider.disconnect();
        publishProvider2.disconnect();
        filterString = this.createJsonFilter("", "", "");
        producersAsJsonString = this.server.getActiveMQServerControl().listProducers(filterString, 1, 50);
        producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
        array = (JsonArray)producersAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)0, (int)array.size(), (String)"number of producers returned from query");
    }

    @Test
    @Timeout(value=60L)
    public void testDirectDeliverFalse() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah", 0);
        for (Binding b : IterableStream.iterableOf(this.server.getPostOffice().getAllBindings().filter(QueueBinding.class::isInstance))) {
            Assertions.assertFalse((boolean)((QueueBinding)b).getQueue().isDirectDeliver(), (String)("Queue " + ((QueueBinding)b).getQueue().getName()));
        }
        subscriptionProvider.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testUnsubscribeMQTT() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        String topic = "foo/bah";
        subscriptionProvider.subscribe(topic, 0);
        CountDownLatch latch = new CountDownLatch(125);
        Thread thread = new Thread(() -> {
            for (int i = 0; i < 250; ++i) {
                try {
                    byte[] payload = subscriptionProvider.receive(10000);
                    Assertions.assertNotNull((Object)payload, (String)"Should get a message");
                    latch.countDown();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            if (i == 125) {
                subscriptionProvider.unsubscribe(topic);
            }
            publishProvider.publish(topic, payload.getBytes(), 1);
        }
        latch.await(20L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSendAtMostOnceReceiveExactlyOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 0);
            byte[] message = provider.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testManagementQueueMessagesAreAckd() throws Exception {
        String clientId = "test.client.id";
        MQTTClientProvider provider = this.getMQTTClientProvider();
        provider.setClientId(clientId);
        this.initializeConnection(provider);
        provider.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 2);
            byte[] message = provider.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        Queue queue = this.server.locateQueue(SimpleString.of((String)("$sys.mqtt.queue.qos2." + clientId)));
        Wait.waitFor(() -> queue.getMessageCount() == 0L, (long)1000L, (long)100L);
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        provider.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testSendAtLeastOnceReceiveExactlyOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 1);
            byte[] message = provider.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testSendAtLeastOnceReceiveAtMostOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 0);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 1);
            byte[] message = provider.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveAtMostOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 0);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 0);
            byte[] message = provider.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testSendAndReceiveAtLeastOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 1);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 1);
            byte[] message = provider.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveExactlyOnceWithInterceptors() throws Exception {
        MQTTTestSupport.MQTTIncomingInterceptor.clear();
        MQTTTestSupport.MQTTOutoingInterceptor.clear();
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        subscriber.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            publisher.publish("foo", payload.getBytes(), 2);
            byte[] message = subscriber.receive(5000);
            Assertions.assertNotNull((Object)message, (String)("Should get a message + [" + i + "]"));
            Assertions.assertEquals((Object)payload, (Object)new String(message));
        }
        subscriber.disconnect();
        publisher.disconnect();
        Assertions.assertEquals((int)250, (int)MQTTTestSupport.MQTTIncomingInterceptor.getMessageCount());
        Assertions.assertEquals((int)250, (int)MQTTTestSupport.MQTTOutoingInterceptor.getMessageCount());
    }

    @Disabled
    @Test
    @Timeout(value=600L)
    public void testSendMoreThanUniqueId() throws Exception {
        int messages = MQTTUtil.TWO_BYTE_INT_MAX;
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        int count = 0;
        subscriber.subscribe("foo", 2);
        for (int i = 0; i < messages; ++i) {
            String payload = "Test Message: " + i;
            publisher.publish("foo", payload.getBytes(), 2);
            byte[] message = subscriber.receive(5000);
            Assertions.assertNotNull((Object)message, (String)("Should get a message + [" + i + "]"));
            Assertions.assertEquals((Object)payload, (Object)new String(message));
            ++count;
        }
        Assertions.assertEquals((int)messages, (int)count);
        subscriber.disconnect();
        publisher.disconnect();
    }

    @Test
    @Timeout(value=180L)
    public void testNoMessageIdReuseBeforeAcknowledgment() throws Exception {
        int messages = MQTTUtil.TWO_BYTE_INT_MAX;
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        final short[] messageId = new short[1];
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                if (frame.messageType() == 3) {
                    try {
                        PUBLISH publish = new PUBLISH();
                        publish.decode(frame);
                        messageId[0] = publish.messageId();
                    }
                    catch (ProtocolException e) {
                        Assertions.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                }
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.subscribe(new Topic[]{new Topic("foo", QoS.EXACTLY_ONCE)});
        publisher.publish("foo", "First Message".getBytes(), 2);
        org.fusesource.mqtt.client.Message firstMessage = connection.receive(5000L, TimeUnit.MILLISECONDS);
        short firstMessageId = messageId[0];
        publisher.publish("foo", "Second Message".getBytes(), 2);
        org.fusesource.mqtt.client.Message secondMessage = connection.receive(5000L, TimeUnit.MILLISECONDS);
        short secondMessageId = messageId[0];
        int count = 0;
        for (int i = 0; i < messages; ++i) {
            String payload = "Test Message: " + i;
            publisher.publish("foo", payload.getBytes(), 2);
            org.fusesource.mqtt.client.Message message = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)message, (String)("Should get a message + [" + i + "]"));
            Assertions.assertEquals((Object)payload, (Object)new String(message.getPayload()));
            Assertions.assertFalse((firstMessageId == messageId[0] || secondMessageId == messageId[0] ? (byte)1 : 0) != 0, (String)"Message ID must not be reused until previous message acknowledgment");
            message.ack();
            ++count;
        }
        firstMessage.ack();
        secondMessage.ack();
        Assertions.assertEquals((int)messages, (int)count);
        connection.unsubscribe(new String[]{"foo"});
        connection.disconnect();
        publisher.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveLargeMessages() throws Exception {
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 50;
        }
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        subscriber.subscribe("foo", 1);
        for (int i = 0; i < 10; ++i) {
            publisher.publish("foo", payload, 1);
            byte[] message = subscriber.receive(5000);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            Assertions.assertArrayEquals((byte[])payload, (byte[])message);
        }
        subscriber.disconnect();
        publisher.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveRetainedMessages() throws Exception {
        int i;
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        String RETAINED = "retained";
        publisher.publish("foo", RETAINED.getBytes(), 1, true);
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (i = 0; i < 10; ++i) {
            messages.add((CallSite)((Object)("TEST MESSAGE:" + i)));
        }
        subscriber.subscribe("foo", 1);
        for (i = 0; i < 10; ++i) {
            publisher.publish("foo", ((String)messages.get(i)).getBytes(), 1);
        }
        byte[] msg = subscriber.receive(5000);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)RETAINED, (Object)new String(msg));
        for (int i2 = 0; i2 < 10; ++i2) {
            msg = subscriber.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals(messages.get(i2), (Object)new String(msg));
        }
        subscriber.disconnect();
        publisher.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveRetainedLargeMessage() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            byte[] payload = new byte[204800];
            for (int i = 0; i < payload.length; ++i) {
                payload[i] = 50;
            }
            String body = "message";
            String smallRetain = "retain";
            MQTTClientProvider publisher = this.getMQTTClientProvider();
            this.initializeConnection(publisher);
            MQTTClientProvider subscriber = this.getMQTTClientProvider();
            this.initializeConnection(subscriber);
            publisher.publish("foo", payload, 1, true);
            subscriber.subscribe("foo", 1);
            publisher.publish("foo", body.getBytes(), 1, false);
            byte[] msg = subscriber.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)msg.length, (int)payload.length);
            msg = subscriber.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)msg.length, (int)body.length());
            subscriber.disconnect();
            MQTTClientProvider subscriber2 = this.getMQTTClientProvider();
            this.initializeConnection(subscriber2);
            subscriber2.subscribe("foo", 1);
            msg = subscriber2.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)msg.length, (int)payload.length);
            subscriber2.disconnect();
            publisher.publish("foo", smallRetain.getBytes(), 1, true);
            MQTTClientProvider subscriber3 = this.getMQTTClientProvider();
            this.initializeConnection(subscriber3);
            subscriber3.subscribe("foo", 1);
            msg = subscriber3.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)msg.length, (int)smallRetain.getBytes().length);
            subscriber3.disconnect();
            publisher.disconnect();
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"Exception"}));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testValidZeroLengthClientId() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("");
        mqtt.setCleanSession(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testMQTTPathPatterns() throws Exception {
        String[] wildcards;
        String[] topics;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("");
        mqtt.setCleanSession(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String RETAINED = "RETAINED";
        for (String topic : topics = new String[]{"TopicA", "/TopicA", "/", "TopicA/", "//"}) {
            connection.publish(topic, ("RETAINED" + topic).getBytes(), QoS.AT_LEAST_ONCE, true);
            connection.subscribe(new Topic[]{new Topic(topic, QoS.AT_LEAST_ONCE)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No message for " + topic));
            Assertions.assertEquals((Object)("RETAINED" + topic), (Object)new String(msg.getPayload()));
            msg.ack();
            connection.publish(topic, topic.getBytes(), QoS.AT_LEAST_ONCE, false);
            msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)topic, (Object)new String(msg.getPayload()));
            msg.ack();
            connection.unsubscribe(new String[]{topic});
        }
        connection.disconnect();
        for (String wildcard : wildcards = new String[]{"#", "+", "+/#", "/+", "+/", "+/+", "+/+/", "+/+/+"}) {
            Pattern pattern = Pattern.compile(wildcard.replaceAll("/?#", "(/?.*)*").replaceAll("\\+", "[^/]*"));
            connection = mqtt.blockingConnection();
            connection.connect();
            byte[] qos = connection.subscribe(new Topic[]{new Topic(wildcard, QoS.AT_LEAST_ONCE)});
            Assertions.assertNotEquals((byte)-128, (byte)qos[0], (String)("Subscribe failed " + wildcard));
            org.fusesource.mqtt.client.Message msg = connection.receive(5L, TimeUnit.SECONDS);
            do {
                Assertions.assertNotNull((Object)msg, (String)("RETAINED null " + wildcard));
                String msgPayload = new String(msg.getPayload());
                Assertions.assertTrue((boolean)msgPayload.startsWith("RETAINED"), (String)("RETAINED prefix " + wildcard + " msg " + msgPayload));
                Assertions.assertTrue((boolean)pattern.matcher(msg.getTopic()).matches(), (String)("RETAINED matching " + wildcard + " " + msg.getTopic()));
                msg.ack();
            } while ((msg = connection.receive(500L, TimeUnit.MILLISECONDS)) != null);
            for (String topic : topics) {
                connection.publish(topic, topic.getBytes(), QoS.AT_LEAST_ONCE, false);
            }
            msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            do {
                Assertions.assertNotNull((Object)msg, (String)("Non-retained Null " + wildcard));
                Assertions.assertTrue((boolean)pattern.matcher(msg.getTopic()).matches(), (String)("Non-retained matching " + wildcard + " " + msg.getTopic()));
                msg.ack();
            } while ((msg = connection.receive(500L, TimeUnit.MILLISECONDS)) != null);
            connection.unsubscribe(new String[]{wildcard});
            connection.disconnect();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testMQTTRetainQoS() throws Exception {
        String[] topics = new String[]{"AT_MOST_ONCE", "AT_LEAST_ONCE", "EXACTLY_ONCE"};
        for (int i = 0; i < topics.length; ++i) {
            String topic = topics[i];
            MQTT mqtt = this.createMQTTConnection();
            mqtt.setClientId("foo");
            mqtt.setKeepAlive((short)2);
            final int[] actualQoS = new int[]{-1};
            mqtt.setTracer(new Tracer(){

                public void onReceive(MQTTFrame frame) {
                    if (frame.messageType() == 3) {
                        actualQoS[0] = frame.qos().ordinal();
                    }
                }
            });
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish(topic, topic.getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic(topic, QoS.valueOf((String)topic))});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)topic, (Object)new String(msg.getPayload()));
            Wait.assertEquals((int)i, () -> actualQoS[0]);
            msg.ack();
            connection.unsubscribe(new String[]{topic});
            connection.disconnect();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testDuplicateSubscriptions() throws Exception {
        QoS[] qoss;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)20);
        final int[] actualQoS = new int[]{-1};
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                if (frame.messageType() == 3) {
                    actualQoS[0] = frame.qos().ordinal();
                }
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String RETAIN = "RETAIN";
        connection.publish("TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
        for (QoS qos : qoss = new QoS[]{QoS.AT_MOST_ONCE, QoS.AT_MOST_ONCE, QoS.AT_LEAST_ONCE, QoS.EXACTLY_ONCE}) {
            connection.subscribe(new Topic[]{new Topic("TopicA", qos)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No message for " + qos));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Wait.assertEquals((int)qos.ordinal(), () -> actualQoS[0]);
            actualQoS[0] = -1;
        }
        connection.unsubscribe(new String[]{"TopicA"});
        connection.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testRetainedMessage() throws Exception {
        String[] clientIds;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setKeepAlive((short)60);
        String RETAIN = "RETAIN";
        String TOPICA = "TopicA";
        for (String clientId : clientIds = new String[]{null, "foo", "durable"}) {
            logger.debug("Testing now with Client ID: {}", (Object)clientId);
            mqtt.setClientId(clientId);
            mqtt.setCleanSession(!"durable".equals(clientId));
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No retained message for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(15000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No retained message on duplicate subscription for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.unsubscribe(new String[]{"TopicA"});
            connection.publish("TopicA", "".getBytes(), QoS.AT_MOST_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)msg, (String)("Retained message not cleared for " + clientId));
            connection.unsubscribe(new String[]{"TopicA"});
            connection.publish("TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No reset retained message for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.disconnect();
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No reset retained message for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.unsubscribe(new String[]{"TopicA"});
            connection.disconnect();
        }
    }

    @Disabled
    @Test
    @Timeout(value=120L)
    public void testRetainedMessageOnVirtualTopics() throws Exception {
        String[] clientIds;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setKeepAlive((short)60);
        String RETAIN = "RETAIN";
        String TOPICA = "VirtualTopic/TopicA";
        for (String clientId : clientIds = new String[]{null, "foo", "durable"}) {
            logger.debug("Testing now with Client ID: {}", (Object)clientId);
            mqtt.setClientId(clientId);
            mqtt.setCleanSession(!"durable".equals(clientId));
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("VirtualTopic/TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No retained message for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(15000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No retained message on duplicate subscription for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.unsubscribe(new String[]{"VirtualTopic/TopicA"});
            connection.publish("VirtualTopic/TopicA", "".getBytes(), QoS.AT_MOST_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(500L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)msg, (String)("Retained message not cleared for " + clientId));
            connection.unsubscribe(new String[]{"VirtualTopic/TopicA"});
            connection.publish("VirtualTopic/TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No reset retained message for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.disconnect();
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg, (String)("No reset retained message for " + clientId));
            Assertions.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            logger.debug("Test now unsubscribing from: {} for the last time", (Object)"VirtualTopic/TopicA");
            connection.unsubscribe(new String[]{"VirtualTopic/TopicA"});
            connection.disconnect();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testUniqueMessageIds() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)2);
        mqtt.setCleanSession(true);
        final ArrayList publishList = new ArrayList();
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                logger.debug("Client received:\n{}", (Object)frame);
                if (frame.messageType() == 3) {
                    PUBLISH publish = new PUBLISH();
                    try {
                        publish.decode(frame);
                    }
                    catch (ProtocolException e) {
                        Assertions.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                    publishList.add(publish);
                }
            }

            public void onSend(MQTTFrame frame) {
                logger.debug("Client sent:\n{}", (Object)frame);
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        QoS[] qoss = new QoS[]{QoS.AT_MOST_ONCE, QoS.AT_LEAST_ONCE, QoS.EXACTLY_ONCE};
        String TOPIC = "TopicA/";
        connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, true);
        String[] subs = new String[]{"TopicA/", "TopicA/#", "TopicA/+"};
        for (int i = 0; i < qoss.length; ++i) {
            connection.subscribe(new Topic[]{new Topic(subs[i], qoss[i])});
        }
        connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
        int received = 0;
        org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
        do {
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
            for (int waitCount = 0; publishList.size() <= received && waitCount < 10; ++waitCount) {
                Thread.sleep(1000L);
            }
        } while ((msg = connection.receive(5000L, TimeUnit.MILLISECONDS)) != null && received++ < subs.length * 2);
        Assertions.assertEquals((int)(subs.length * 2), (int)(received + 1), (String)"Unexpected number of messages");
        for (int i = 0; i < publishList.size(); ++i) {
            for (int j = i + 1; j < publishList.size(); ++j) {
                PUBLISH publish1 = (PUBLISH)publishList.get(i);
                PUBLISH publish2 = (PUBLISH)publishList.get(j);
                boolean qos0 = false;
                if (publish1.qos() == QoS.AT_MOST_ONCE) {
                    qos0 = true;
                    Assertions.assertEquals((int)0, (int)publish1.messageId());
                }
                if (publish2.qos() == QoS.AT_MOST_ONCE) {
                    qos0 = true;
                    Assertions.assertEquals((int)0, (int)publish2.messageId());
                }
                if (qos0) continue;
                Assertions.assertNotEquals((short)publish1.messageId(), (short)publish2.messageId());
            }
        }
        connection.unsubscribe(subs);
        connection.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testResendMessageId() throws Exception {
        MQTT mqtt = this.createMQTTConnection("resend", false);
        mqtt.setKeepAlive((short)5);
        final ArrayList publishList = new ArrayList();
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                logger.debug("Client received:\n{}", (Object)frame);
                if (frame.messageType() == 3) {
                    PUBLISH publish = new PUBLISH();
                    try {
                        publish.decode(frame);
                    }
                    catch (ProtocolException e) {
                        Assertions.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                    publishList.add(publish);
                }
            }

            public void onSend(MQTTFrame frame) {
                logger.debug("Client sent:\n{}", (Object)frame);
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String TOPIC = "TopicA/";
        String[] topics = new String[]{"TopicA/", "TopicA/+"};
        connection.subscribe(new Topic[]{new Topic(topics[0], QoS.AT_LEAST_ONCE), new Topic(topics[1], QoS.EXACTLY_ONCE)});
        connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> publishList.size() == 2, (long)5000L));
        connection.disconnect();
        connection = mqtt.blockingConnection();
        connection.connect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> publishList.size() == 4, (long)5000L));
        connection.unsubscribe(topics);
        connection.disconnect();
    }

    @Test
    @Timeout(value=90L)
    public void testPacketIdGeneratorNonCleanSession() throws Exception {
        int i;
        MQTT mqtt = this.createMQTTConnection("nonclean-packetid", false);
        mqtt.setKeepAlive((short)15);
        final ConcurrentHashMap publishMap = new ConcurrentHashMap();
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                logger.debug("Client received:\n{}", (Object)frame);
                if (frame.messageType() == 3) {
                    PUBLISH publish = new PUBLISH();
                    try {
                        publish.decode(frame);
                        logger.debug("PUBLISH {}", (Object)publish);
                    }
                    catch (ProtocolException e) {
                        Assertions.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                    if (publishMap.get(publish.messageId()) != null) {
                        Assertions.assertTrue((boolean)publish.dup());
                    }
                    publishMap.put(publish.messageId(), publish);
                }
            }

            public void onSend(MQTTFrame frame) {
                logger.debug("Client sent:\n{}", (Object)frame);
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String TOPIC = "TopicA/";
        connection.subscribe(new Topic[]{new Topic("TopicA/", QoS.EXACTLY_ONCE)});
        int TOTAL_MESSAGES = 10;
        for (i = 0; i < 10; ++i) {
            connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
        }
        for (i = 0; i < 5; ++i) {
            org.fusesource.mqtt.client.Message msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
        }
        connection.disconnect();
        connection = mqtt.blockingConnection();
        connection.connect();
        org.fusesource.mqtt.client.Message msg = null;
        do {
            if ((msg = connection.receive(1000L, TimeUnit.MILLISECONDS)) == null) continue;
            Assertions.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
        } while (msg != null);
        for (short id = 1; id <= 10; id = (short)(id + 1)) {
            Assertions.assertNotNull(publishMap.get(id), (String)("No message for id " + id));
        }
        connection.unsubscribe(new String[]{"TopicA/"});
        connection.disconnect();
    }

    @Disabled
    @Test
    @Timeout(value=90L)
    public void testPacketIdGeneratorCleanSession() throws Exception {
        String[] cleanClientIds = new String[]{"", "clean-packetid", null};
        final ConcurrentHashMap publishMap = new ConcurrentHashMap();
        MQTT[] mqtts = new MQTT[cleanClientIds.length];
        for (int i = 0; i < cleanClientIds.length; ++i) {
            mqtts[i] = this.createMQTTConnection("", true);
            mqtts[i].setKeepAlive((short)15);
            mqtts[i].setTracer(new Tracer(){

                public void onReceive(MQTTFrame frame) {
                    logger.debug("Client received:\n{}", (Object)frame);
                    if (frame.messageType() == 3) {
                        PUBLISH publish = new PUBLISH();
                        try {
                            publish.decode(frame);
                            logger.debug("PUBLISH {}", (Object)publish);
                        }
                        catch (ProtocolException e) {
                            Assertions.fail((String)("Error decoding publish " + e.getMessage()));
                        }
                        if (publishMap.get(publish.messageId()) != null) {
                            Assertions.assertTrue((boolean)publish.dup());
                        }
                        publishMap.put(publish.messageId(), publish);
                    }
                }

                public void onSend(MQTTFrame frame) {
                    logger.debug("Client sent:\n{}", (Object)frame);
                }
            });
        }
        Random random = new Random();
        for (int i = 0; i < 10; i = (int)((short)(i + 1))) {
            BlockingConnection connection = mqtts[random.nextInt(cleanClientIds.length)].blockingConnection();
            connection.connect();
            String TOPIC = "TopicA/";
            connection.subscribe(new Topic[]{new Topic("TopicA/", QoS.EXACTLY_ONCE)});
            connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
            org.fusesource.mqtt.client.Message msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
            Assertions.assertEquals((int)1, (int)publishMap.size());
            short id = (short)(i + 1);
            Assertions.assertNotNull(publishMap.get(id), (String)("No message for id " + id));
            publishMap.clear();
            connection.disconnect();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testClientConnectionFailure() throws Exception {
        MQTT mqtt = this.createMQTTConnection("reconnect", false);
        mqtt.setKeepAlive((short)1);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Wait.waitFor(() -> connection.isConnected());
        String TOPIC = "TopicA";
        byte[] qos = connection.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        Assertions.assertEquals((int)QoS.EXACTLY_ONCE.ordinal(), (int)qos[0]);
        connection.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        connection.kill();
        BlockingConnection newConnection = mqtt.blockingConnection();
        newConnection.connect();
        Wait.waitFor(() -> newConnection.isConnected());
        Assertions.assertEquals((int)QoS.EXACTLY_ONCE.ordinal(), (int)qos[0]);
        org.fusesource.mqtt.client.Message msg = newConnection.receive(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)"TopicA", (Object)new String(msg.getPayload()));
        msg.ack();
        newConnection.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testClientConnectionFailureSendsWillMessage() throws Exception {
        this.getServer().createQueue(QueueConfiguration.of((String)"will"));
        MQTT mqtt = this.createMQTTConnection("1", false);
        mqtt.setKeepAlive((short)1);
        mqtt.setWillMessage("test message");
        mqtt.setWillTopic("will");
        mqtt.setWillQos(QoS.AT_LEAST_ONCE);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Wait.waitFor(() -> connection.isConnected());
        MQTT mqtt2 = this.createMQTTConnection("2", false);
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(new Topic[]{new Topic("will", QoS.AT_LEAST_ONCE)});
        connection.kill();
        org.fusesource.mqtt.client.Message m = connection2.receive(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"test message", (Object)new String(m.getPayload()));
    }

    @Test
    @Timeout(value=60L)
    public void testWillMessageIsRetained() throws Exception {
        this.getServer().createQueue(QueueConfiguration.of((String)"will"));
        MQTT mqtt = this.createMQTTConnection("1", false);
        mqtt.setKeepAlive((short)1);
        mqtt.setWillMessage("test message");
        mqtt.setWillTopic("will");
        mqtt.setWillQos(QoS.AT_LEAST_ONCE);
        mqtt.setWillRetain(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Wait.waitFor(() -> connection.isConnected());
        connection.kill();
        Thread.sleep(10000L);
        MQTT mqtt2 = this.createMQTTConnection("2", false);
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(new Topic[]{new Topic("will", QoS.AT_LEAST_ONCE)});
        org.fusesource.mqtt.client.Message m = connection2.receive(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)m);
        m.ack();
        Assertions.assertEquals((Object)"test message", (Object)new String(m.getPayload()));
    }

    @Test
    @Timeout(value=60L)
    public void testCleanSessionForSubscriptions() throws Exception {
        String CLIENTID = "cleansession";
        MQTT mqttNotClean = this.createMQTTConnection("cleansession", false);
        BlockingConnection notClean = mqttNotClean.blockingConnection();
        String TOPIC = "TopicA";
        notClean.connect();
        notClean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        notClean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        notClean.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessions().size());
        notClean = mqttNotClean.blockingConnection();
        notClean.connect();
        org.fusesource.mqtt.client.Message msg = notClean.receive(10000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)"TopicA", (Object)new String(msg.getPayload()));
        msg.ack();
        notClean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        notClean.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessions().size());
        MQTT mqttClean = this.createMQTTConnection("cleansession", true);
        BlockingConnection clean = mqttClean.blockingConnection();
        clean.connect();
        msg = clean.receive(100L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)msg);
        clean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        clean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        clean.disconnect();
        Assertions.assertEquals((int)0, (int)this.getSessions().size());
        notClean = mqttNotClean.blockingConnection();
        notClean.connect();
        msg = notClean.receive(100L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)msg);
        notClean.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessions().size());
    }

    @Test
    @Timeout(value=60L)
    public void testCleanSessionForMessages() throws Exception {
        String CLIENTID = "cleansession";
        MQTT mqttNotClean = this.createMQTTConnection("cleansession", false);
        BlockingConnection notClean = mqttNotClean.blockingConnection();
        String TOPIC = "TopicA";
        notClean.connect();
        notClean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        notClean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        notClean.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessions().size());
        MQTT mqttClean = this.createMQTTConnection("cleansession", true);
        BlockingConnection clean = mqttClean.blockingConnection();
        clean.connect();
        clean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        org.fusesource.mqtt.client.Message msg = clean.receive(100L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)msg);
        clean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        clean.disconnect();
        Assertions.assertEquals((int)0, (int)this.getSessions().size());
    }

    @Test
    @Timeout(value=60L)
    public void testSendMQTTReceiveJMS() throws Exception {
        this.doTestSendMQTTReceiveJMS("foo.*", "foo/bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testLinkRouteAmqpReceiveMQTT() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("TestClient");
        BlockingConnection blockingConnection = mqtt.blockingConnection();
        blockingConnection.connect();
        Topic t = new Topic("test", QoS.AT_LEAST_ONCE);
        blockingConnection.subscribe(new Topic[]{t});
        AmqpClient client = new AmqpClient(new URI(AMQP_URI), null, null);
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender("test", true);
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message");
            sender.send(message);
            sender.close();
        }
        try {
            blockingConnection.subscribe(new Topic[]{t});
            Assertions.assertNotNull((Object)blockingConnection.receive(5L, TimeUnit.SECONDS));
        }
        finally {
            blockingConnection.kill();
        }
    }

    public void doTestSendMQTTReceiveJMS(String jmsTopicAddress, String mqttAddress) throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        String address = mqttAddress;
        String RETAINED = "RETAINED";
        byte[] payload = "RETAINED".getBytes();
        Connection connection = this.cf.createConnection();
        connection.start();
        Session s = connection.createSession(false, 1);
        jakarta.jms.Topic jmsTopic = s.createTopic(jmsTopicAddress);
        MessageConsumer consumer = s.createConsumer((Destination)jmsTopic);
        provider.publish(address, "RETAINED".getBytes(), 1, true);
        BytesMessage message = (BytesMessage)consumer.receive(5000L);
        Assertions.assertNotNull((Object)message, (String)"Should get retained message");
        byte[] b = new byte[8];
        message.readBytes(b);
        Assertions.assertArrayEquals((byte[])payload, (byte[])b);
        for (int i = 0; i < 250; ++i) {
            String p = "Test Message: " + i;
            provider.publish(address, p.getBytes(), 1);
            message = (BytesMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message, (String)"Should get a message");
            byte[] bytePayload = new byte[p.getBytes().length];
            message.readBytes(bytePayload);
            Assertions.assertArrayEquals((byte[])payload, (byte[])b);
        }
        connection.close();
        provider.disconnect();
    }

    @Test
    @Timeout(value=120L)
    public void testSendJMSReceiveMQTT() throws Exception {
        this.doTestSendJMSReceiveMQTT("foo.far");
    }

    public void doTestSendJMSReceiveMQTT(String destinationName) throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo/+", 0);
        Connection connection = this.cf.createConnection();
        connection.start();
        Session s = connection.createSession(false, 1);
        jakarta.jms.Topic topic = s.createTopic(destinationName);
        MessageProducer producer = s.createProducer((Destination)topic);
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        BytesMessage bytesMessage = s.createBytesMessage();
        bytesMessage.writeBytes(bytes);
        producer.send((Message)bytesMessage);
        byte[] message = provider.receive(10000);
        Assertions.assertNotNull((Object)message, (String)"Should get retained message");
        Assertions.assertArrayEquals((byte[])bytes, (byte[])message);
        provider.disconnect();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPingKeepsInactivityMonitorAlive() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection.isConnected()), (String)"KeepAlive didn't work properly");
        connection.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testTurnOffInactivityMonitor() throws Exception {
        this.stopBroker();
        this.protocolConfig = "transport.useInactivityMonitor=false";
        this.startBroker();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo3");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection.isConnected()), (String)"KeepAlive didn't work properly");
        connection.disconnect();
    }

    @Disabled
    @Test
    @Timeout(value=60L)
    public void testPublishDollarTopics() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        String clientId = "publishDollar";
        mqtt.setClientId("publishDollar");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String DOLLAR_TOPIC = "$TopicA";
        connection.subscribe(new Topic[]{new Topic("$TopicA", QoS.EXACTLY_ONCE)});
        connection.publish("$TopicA", "$TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        org.fusesource.mqtt.client.Message message = connection.receive(100L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)message, (String)"Publish enabled for $ Topics by default");
        connection.disconnect();
        this.stopBroker();
        this.protocolConfig = "transport.publishDollarTopics=true";
        this.startBroker();
        mqtt = this.createMQTTConnection();
        mqtt.setClientId("publishDollar");
        mqtt.setKeepAlive((short)2);
        connection = mqtt.blockingConnection();
        connection.connect();
        connection.subscribe(new Topic[]{new Topic("$TopicA", QoS.EXACTLY_ONCE)});
        connection.publish("$TopicA", "$TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        message = connection.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.ack();
        Assertions.assertEquals((Object)"$TopicA", (Object)new String(message.getPayload()), (String)"Message body");
        connection.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testDuplicateClientId() throws Exception {
        String clientId = "duplicateClient";
        MQTT mqtt = this.createMQTTConnection("duplicateClient", false);
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String TOPICA = "TopicA";
        connection.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        MQTT mqtt1 = this.createMQTTConnection("duplicateClient", false);
        mqtt1.setKeepAlive((short)2);
        BlockingConnection connection1 = mqtt1.blockingConnection();
        connection1.connect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection1.isConnected()), (String)"Duplicate client disconnected");
        Assertions.assertTrue((boolean)Wait.waitFor(() -> !connection.isConnected()), (String)"Old client still connected");
        connection1.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        connection1.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testRepeatedLinkStealing() throws Exception {
        String clientId = "duplicateClient";
        AtomicReference<BlockingConnection> oldConnection = new AtomicReference<BlockingConnection>();
        String TOPICA = "TopicA";
        for (int i = 1; i <= 10; ++i) {
            logger.debug("Creating MQTT Connection {}", (Object)i);
            MQTT mqtt = this.createMQTTConnection("duplicateClient", false);
            mqtt.setKeepAlive((short)2);
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> connection.isConnected(), (long)3000L, (long)200L), (String)("Client connect failed for attempt: " + i));
            if (oldConnection.get() != null) {
                Assertions.assertTrue((boolean)Wait.waitFor(() -> !((BlockingConnection)oldConnection.get()).isConnected(), (long)3000L, (long)200L), (String)("Old client still connected on attempt: " + i));
            }
            oldConnection.set(connection);
        }
        ((BlockingConnection)oldConnection.get()).publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        ((BlockingConnection)oldConnection.get()).disconnect();
    }

    @Test
    @Timeout(value=30L)
    public void testJmsMapping() throws Exception {
        this.doTestJmsMapping("test.foo");
    }

    public void doTestJmsMapping(String destinationName) throws Exception {
        int i;
        Connection jmsConn = this.cf.createConnection();
        Session session = jmsConn.createSession(false, 1);
        jakarta.jms.Queue dest = session.createQueue(destinationName);
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        jmsConn.start();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo3");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        int messagesToSend = 5;
        for (i = 0; i < messagesToSend; ++i) {
            connection.publish("test/foo", "hello world".getBytes(), QoS.AT_LEAST_ONCE, false);
        }
        connection.disconnect();
        for (i = 0; i < messagesToSend; ++i) {
            Message message = consumer.receive(2000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertTrue((boolean)(message instanceof BytesMessage));
            BytesMessage bytesMessage = (BytesMessage)message;
            int length = (int)bytesMessage.getBodyLength();
            byte[] buffer = new byte[length];
            bytesMessage.readBytes(buffer);
            Assertions.assertEquals((Object)"hello world", (Object)new String(buffer));
        }
        jmsConn.close();
    }

    @Test
    @Timeout(value=30L)
    public void testSubscribeMultipleTopics() throws Exception {
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 50;
        }
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("MQTT-Client");
        mqtt.setCleanSession(false);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Topic[] topics = new Topic[]{new Topic("Topic/A", QoS.EXACTLY_ONCE), new Topic("Topic/B", QoS.EXACTLY_ONCE)};
        Topic[] wildcardTopic = new Topic[]{new Topic("Topic/#", QoS.AT_LEAST_ONCE)};
        connection.subscribe(wildcardTopic);
        for (Topic topic : topics) {
            connection.publish(topic.name().toString(), payload, QoS.AT_LEAST_ONCE, false);
        }
        int received = 0;
        for (int i = 0; i < topics.length; ++i) {
            org.fusesource.mqtt.client.Message message = connection.receive();
            Assertions.assertNotNull((Object)message);
            ++received;
            payload = message.getPayload();
            String messageContent = new String(payload);
            logger.debug("Received message from topic: {} Message content: {}", (Object)message.getTopic(), (Object)messageContent);
            message.ack();
        }
        Assertions.assertEquals((int)topics.length, (int)received, (String)("Should have received " + topics.length + " messages"));
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMessageSentWhileOffline() throws Exception {
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 50;
        }
        int numberOfRuns = 100;
        int messagesPerRun = 2;
        MQTT mqttPub = this.createMQTTConnection("MQTT-Pub-Client", true);
        MQTT mqttSub = this.createMQTTConnection("MQTT-Sub-Client", false);
        BlockingConnection connectionPub = mqttPub.blockingConnection();
        connectionPub.connect();
        BlockingConnection connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        Topic[] topics = new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)};
        connectionSub.subscribe(topics);
        for (int i = 0; i < messagesPerRun; ++i) {
            connectionPub.publish(topics[0].name().toString(), payload, QoS.AT_LEAST_ONCE, false);
        }
        int received = 0;
        for (int i = 0; i < messagesPerRun; ++i) {
            org.fusesource.mqtt.client.Message message = connectionSub.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            ++received;
            Assertions.assertTrue((boolean)Arrays.equals(payload, message.getPayload()));
            message.ack();
        }
        connectionSub.disconnect();
        for (int j = 0; j < numberOfRuns; ++j) {
            int i;
            for (i = 0; i < messagesPerRun; ++i) {
                connectionPub.publish(topics[0].name().toString(), payload, QoS.AT_LEAST_ONCE, false);
            }
            connectionSub = mqttSub.blockingConnection();
            connectionSub.connect();
            connectionSub.subscribe(topics);
            for (i = 0; i < messagesPerRun; ++i) {
                org.fusesource.mqtt.client.Message message = connectionSub.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)message);
                ++received;
                Assertions.assertTrue((boolean)Arrays.equals(payload, message.getPayload()));
                message.ack();
            }
            connectionSub.disconnect();
        }
        Assertions.assertEquals((int)(messagesPerRun * (numberOfRuns + 1)), (int)received, (String)("Should have received " + messagesPerRun * (numberOfRuns + 1) + " messages"));
    }

    @Test
    @Timeout(value=60L)
    public void testDefaultSessionExpiryInterval() throws Exception {
        MQTT mqttSub = this.createMQTTConnection("MQTT-Sub-Client", false);
        BlockingConnection connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        Assertions.assertEquals((int)1, (int)this.getSessions().size());
        Topic[] topics = new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)};
        connectionSub.subscribe(topics);
        connectionSub.disconnect();
        Wait.assertEquals((int)1, () -> this.getSessions().size(), (long)10000L, (long)100L);
    }

    @Test
    @Timeout(value=30L)
    public void testDefaultKeepAliveWhenClientSpecifiesZero() throws Exception {
        this.stopBroker();
        this.protocolConfig = "transport.defaultKeepAlive=2000";
        this.startBroker();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)0);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection.isConnected()), (String)"KeepAlive didn't work properly");
    }

    @Test
    @Timeout(value=60L)
    public void testReuseConnection() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("Test-Client");
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
        Thread.sleep(100L);
        connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
        Thread.sleep(100L);
    }

    @Test
    @Timeout(value=60L)
    public void testNoMessageReceivedAfterUnsubscribeMQTT() throws Exception {
        int i;
        Topic[] topics = new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)};
        MQTT mqttPub = this.createMQTTConnection("MQTTPub-Client", true);
        MQTT mqttSub = this.createMQTTConnection("MQTTSub-Client", false);
        BlockingConnection connectionPub = mqttPub.blockingConnection();
        connectionPub.connect();
        BlockingConnection connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        connectionSub.subscribe(topics);
        connectionSub.disconnect();
        for (int i2 = 0; i2 < 5; ++i2) {
            String payload = "Message " + i2;
            connectionPub.publish(topics[0].name().toString(), payload.getBytes(), QoS.EXACTLY_ONCE, false);
        }
        connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        int received = 0;
        for (i = 0; i < 5; ++i) {
            org.fusesource.mqtt.client.Message message = connectionSub.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)("Missing message " + i));
            logger.debug("Message is {}", (Object)new String(message.getPayload()));
            ++received;
            message.ack();
        }
        Assertions.assertEquals((int)5, (int)received);
        connectionSub.unsubscribe(new String[]{"TopicA"});
        for (i = 0; i < 5; ++i) {
            String payload = "Message " + i;
            connectionPub.publish(topics[0].name().toString(), payload.getBytes(), QoS.EXACTLY_ONCE, false);
        }
        Assertions.assertNull((Object)connectionSub.receive(100L, TimeUnit.MILLISECONDS));
        connectionSub.disconnect();
        connectionPub.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testMQTT311Connection() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setVersion("3.1.1");
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testPingOnMQTT() throws Exception {
        this.stopBroker();
        this.protocolConfig = "maxInactivityDuration=-1";
        this.startBroker();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("test-mqtt");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection.isConnected()), (String)"KeepAlive didn't work properly");
        connection.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testClientDisconnectedOnMaxConsumerLimitReached() throws Exception {
        EOFException peerDisconnectedException = null;
        try {
            String clientId = "test.client";
            String coreAddress = MQTTUtil.getCoreAddressFromMqttTopic((String)"foo/bar", (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration());
            Topic[] mqttSubscription = new Topic[]{new Topic("foo/bar", QoS.AT_LEAST_ONCE)};
            this.getServer().createQueue(QueueConfiguration.of((String)MQTTUtil.getCoreQueueFromMqttTopic((String)"foo/bar", (String)clientId, (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration())).setAddress(coreAddress).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)));
            MQTT mqtt = this.createMQTTConnection();
            mqtt.setClientId(clientId);
            mqtt.setKeepAlive((short)2);
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(mqttSubscription);
        }
        catch (EOFException e) {
            peerDisconnectedException = e;
        }
        Assertions.assertNotNull((Object)peerDisconnectedException);
        Assertions.assertTrue((boolean)peerDisconnectedException.getMessage().contains("Peer disconnected"));
    }

    @Test
    @Timeout(value=60L)
    public void testAnycastPrefixWorksWithMQTT() throws Exception {
        String clientId = "testMqtt";
        String anycastAddress = "anycast:foo/bar";
        String sendAddress = "foo/bar";
        Topic[] mqttSubscription = new Topic[]{new Topic(anycastAddress, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.subscribe(mqttSubscription);
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttSubscription);
        String message1 = "TestMessage1";
        String message2 = "TestMessage2";
        connection1.publish(sendAddress, message1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish(sendAddress, message2.getBytes(), QoS.AT_LEAST_ONCE, false);
        Assertions.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNull((Object)connection1.receive(100L, TimeUnit.MILLISECONDS));
        Assertions.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNull((Object)connection2.receive(100L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testAnycastAddressWorksWithMQTT() throws Exception {
        String anycastAddress = "foo/bar";
        this.getServer().addAddressInfo(new AddressInfo(SimpleString.of((String)"foo.bar"), RoutingType.ANYCAST));
        String clientId = "testMqtt";
        Topic[] mqttSubscription = new Topic[]{new Topic(anycastAddress, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.subscribe(mqttSubscription);
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttSubscription);
        String message1 = "TestMessage1";
        String message2 = "TestMessage2";
        connection1.publish(anycastAddress, message1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish(anycastAddress, message2.getBytes(), QoS.AT_LEAST_ONCE, false);
        Assertions.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNull((Object)connection1.receive(100L, TimeUnit.MILLISECONDS));
        Assertions.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNull((Object)connection2.receive(100L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testAmbiguousRoutingWithMQTT() throws Exception {
        String anycastAddress = "foo/bar";
        EnumSet<RoutingType> routingTypeSet = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        this.getServer().addAddressInfo(new AddressInfo(SimpleString.of((String)"foo.bar"), routingTypeSet));
        String clientId = "testMqtt";
        Topic[] mqttSubscription = new Topic[]{new Topic(anycastAddress, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.subscribe(mqttSubscription);
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttSubscription);
        String message1 = "TestMessage1";
        String message2 = "TestMessage2";
        connection1.publish(anycastAddress, message1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish(anycastAddress, message2.getBytes(), QoS.AT_LEAST_ONCE, false);
        Assertions.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
        Assertions.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testRetainedMessagesAreCorrectlyFormedAfterRestart() throws Exception {
        String clientId = "testMqtt";
        String address = "testAddress";
        String payload = "This is a test message";
        this.getServer().addAddressInfo(new AddressInfo(SimpleString.of((String)address), RoutingType.MULTICAST));
        Topic[] mqttTopic = new Topic[]{new Topic(address, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.publish(address, payload.getBytes(), QoS.AT_LEAST_ONCE, true);
        this.getServer().fail(false);
        this.getServer().start();
        this.waitForServerToStart(this.getServer());
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttTopic);
        org.fusesource.mqtt.client.Message message = connection2.receive(5000L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((Object)payload, (Object)new String(message.getPayload()));
    }

    @Test
    @Timeout(value=60L)
    public void testBrokerRestartAfterSubHashWithConfigurationQueues() throws Exception {
        CoreAddressConfiguration coreAddressConfiguration = new CoreAddressConfiguration();
        coreAddressConfiguration.setName("DLA");
        coreAddressConfiguration.addRoutingType(RoutingType.ANYCAST);
        coreAddressConfiguration.addQueueConfiguration(QueueConfiguration.of((String)"DLQ").setAddress("DLA").setRoutingType(RoutingType.ANYCAST));
        this.getServer().getConfiguration().getAddressConfigurations().add(coreAddressConfiguration);
        this.getServer().stop();
        this.getServer().start();
        this.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        for (int i = 0; i < 2; ++i) {
            MQTT mqtt = this.createMQTTConnection("myClient", false);
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(new Topic[]{new Topic("#", QoS.AT_MOST_ONCE)});
            connection.disconnect();
            this.getServer().stop();
            this.getServer().start();
            this.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoubleBroker() throws Exception {
        int port1 = 1884;
        int port2 = 1885;
        Configuration cfg1 = this.createDefaultConfig(1, false);
        cfg1.setResolveProtocols(true).addAcceptorConfiguration("mqtt1", "tcp://localhost:1884?protocols=MQTT");
        Configuration cfg2 = this.createDefaultConfig(2, false);
        cfg2.setResolveProtocols(true).addAcceptorConfiguration("mqtt2", "tcp://localhost:1885?protocols=MQTT");
        ActiveMQServer server1 = this.createServer(cfg1);
        server1.start();
        ActiveMQServer server2 = this.createServer(cfg2);
        server2.start();
        String clientId = "client1";
        MQTT mqtt1 = this.createMQTTConnection("client1", true);
        MQTT mqtt2 = this.createMQTTConnection("client1", true);
        mqtt1.setHost("localhost", 1884);
        mqtt2.setHost("localhost", 1885);
        BlockingConnection connection1 = mqtt1.blockingConnection();
        BlockingConnection connection2 = mqtt2.blockingConnection();
        try {
            connection1.connect();
            connection2.connect();
        }
        catch (Exception e) {
            Assertions.fail((String)"Connections should have worked.");
        }
        finally {
            if (connection1.isConnected()) {
                connection1.disconnect();
            }
            if (connection2.isConnected()) {
                connection2.disconnect();
            }
        }
    }

    @Test
    public void autoDestroyAddress() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAutoDeleteAddresses(Boolean.valueOf(true));
        this.server.getAddressSettingsRepository().addMatch("foo.bar", (Object)addressSettings);
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bar", 0);
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)"foo.bar")));
        subscriptionProvider.disconnect();
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)"foo.bar")) == null);
    }

    @Test
    @Timeout(value=60L)
    public void testAutoDeleteRetainedQueue() throws Exception {
        int i;
        int i2;
        String TOPIC = "/abc/123";
        String RETAINED_QUEUE = MQTTUtil.getCoreRetainAddressFromMqttTopic((String)"/abc/123", (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration());
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.server.getAddressSettingsRepository().addMatch(MQTTUtil.getCoreAddressFromMqttTopic((String)"#", (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration()), (Object)new AddressSettings().setExpiryDelay(Long.valueOf(500L)).setAutoDeleteQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)));
        this.initializeConnection(publisher);
        this.initializeConnection(subscriber);
        String RETAINED = "retained";
        publisher.publish("/abc/123", RETAINED.getBytes(), 1, true);
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (i2 = 0; i2 < 10; ++i2) {
            messages.add((CallSite)((Object)("TEST MESSAGE:" + i2)));
        }
        subscriber.subscribe("/abc/123", 1);
        for (i2 = 0; i2 < 10; ++i2) {
            publisher.publish("/abc/123", ((String)messages.get(i2)).getBytes(), 1);
        }
        byte[] msg = subscriber.receive(5000);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)RETAINED, (Object)new String(msg));
        for (i = 0; i < 10; ++i) {
            msg = subscriber.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals(messages.get(i), (Object)new String(msg));
        }
        subscriber.disconnect();
        publisher.disconnect();
        Wait.assertTrue(() -> this.server.locateQueue(RETAINED_QUEUE).getMessageCount() == 0L, (long)2000L, (long)50L);
        Wait.assertTrue(() -> this.server.locateQueue(RETAINED_QUEUE) == null, (long)2000L, (long)50L);
        this.initializeConnection(publisher);
        this.initializeConnection(subscriber);
        publisher.publish("/abc/123", RETAINED.getBytes(), 1, true);
        subscriber.subscribe("/abc/123", 1);
        for (i = 0; i < 10; ++i) {
            publisher.publish("/abc/123", ((String)messages.get(i)).getBytes(), 1);
        }
        msg = subscriber.receive(5000);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)RETAINED, (Object)new String(msg));
        for (i = 0; i < 10; ++i) {
            msg = subscriber.receive(5000);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals(messages.get(i), (Object)new String(msg));
        }
        subscriber.disconnect();
        publisher.disconnect();
        Wait.assertTrue(() -> this.server.locateQueue(RETAINED_QUEUE).getMessageCount() == 0L, (long)3000L, (long)50L);
        Wait.assertTrue(() -> this.server.locateQueue(RETAINED_QUEUE) == null, (long)3000L, (long)50L);
    }

    @Test
    @Timeout(value=60L)
    public void testRetainFlagOnEstablishedSubscription() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String topic = this.getTopicName();
        MqttClient subscriber = this.createPaho3_1_1Client("subscriber");
        subscriber.setCallback((MqttCallback)new MQTTTestSupport.DefaultMqtt3Callback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                if (!message.isRetained()) {
                    latch.countDown();
                }
            }
        });
        subscriber.connect();
        subscriber.subscribe(topic, 1);
        MqttClient publisher = this.createPaho3_1_1Client("publisher");
        publisher.connect();
        publisher.publish(topic, "retained".getBytes(StandardCharsets.UTF_8), 1, true);
        publisher.disconnect();
        publisher.close();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Did not receive expected message within timeout");
        subscriber.disconnect();
        subscriber.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainFlagOnNewSubscription() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String topic = this.getTopicName();
        MqttClient publisher = this.createPaho3_1_1Client("publisher");
        publisher.connect();
        publisher.publish(topic, "retained".getBytes(StandardCharsets.UTF_8), 1, true);
        publisher.disconnect();
        publisher.close();
        MqttClient subscriber = this.createPaho3_1_1Client("subscriber");
        subscriber.setCallback((MqttCallback)new MQTTTestSupport.DefaultMqtt3Callback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                if (message.isRetained()) {
                    latch.countDown();
                }
            }
        });
        subscriber.connect();
        subscriber.subscribe(topic, 1);
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Did not receive expected message within timeout");
        subscriber.disconnect();
        subscriber.close();
    }
}

