/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PahoMQTTQOS2SecurityTest
extends MQTTTestSupport {
    String user1 = "user1";
    String password1 = "password1";

    @Override
    protected void configureBrokerSecurity(ActiveMQServer server) {
        super.configureBrokerSecurity(server);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser(this.user1, this.password1);
        securityManager.getConfiguration().addRole(this.user1, "addressOnly");
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        HashSet<Role> value = new HashSet<Role>();
        value.add(new Role("addressOnly", true, true, true, true, false, false, false, false, true, true, false, false));
        securityRepository.addMatch(MQTTUtil.getCoreAddressFromMqttTopic((String)this.getQueueName(), (WildcardConfiguration)server.getConfiguration().getWildcardConfiguration()), value);
    }

    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Test
    @Timeout(value=60L)
    public void testSendAndReceiveMQTT() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumerId");
        MqttClient producer = this.createPahoClient("producerId");
        MqttConnectOptions conOpt = new MqttConnectOptions();
        conOpt.setCleanSession(false);
        conOpt.setUserName(this.user1);
        conOpt.setPassword(this.password1.toCharArray());
        consumer.connect(conOpt);
        consumer.subscribe(this.getQueueName(), 2);
        final boolean[] failed = new boolean[1];
        consumer.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                cause.printStackTrace();
                failed[0] = true;
                latch.countDown();
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        producer.connect(conOpt);
        producer.publish(this.getQueueName(), "hello".getBytes(), 2, false);
        PahoMQTTQOS2SecurityTest.waitForLatch(latch);
        producer.disconnect();
        producer.close();
        Assertions.assertFalse((boolean)failed[0]);
    }

    private MqttClient createPahoClient(String clientId) throws MqttException {
        return new MqttClient("tcp://localhost:" + this.getPort(), clientId, (MqttClientPersistence)new MemoryPersistence());
    }
}

