/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.ssl;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class CertificateAuthenticationSslTests
extends MQTT5TestSupport {
    protected String protocol;

    public CertificateAuthenticationSslTests(String protocol) {
        this.protocol = protocol;
    }

    @Parameters(name="protocol={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({"ssl"}, {"wss"});
    }

    @Override
    public boolean isUseSsl() {
        return true;
    }

    @Override
    public boolean isMutualSsl() {
        return true;
    }

    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected void configureBrokerSecurity(ActiveMQServer server) {
        server.setSecurityManager((ActiveMQSecurityManager)new ActiveMQJAASSecurityManager("CertLogin"));
        server.getConfiguration().setSecurityEnabled(true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, false, false, false, false, false, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSimpleSendReceive() throws Exception {
        String topic = RandomUtil.randomString();
        String clientId = "subscriber";
        final byte[] body = RandomUtil.randomBytes((int)32);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient subscriber = this.createPahoClient(this.protocol, "subscriber");
        subscriber.connect(this.getSslMqttConnectOptions());
        subscriber.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                ActiveMQTestBase.assertEqualsByteArrays(body, message.getPayload());
                latch.countDown();
            }
        });
        subscriber.subscribe(topic, 1);
        Wait.assertTrue(() -> this.getSubscriptionQueue(topic, "subscriber") != null, (long)2000L, (long)100L);
        Wait.assertEquals((int)1, () -> this.getSubscriptionQueue(topic, "subscriber").getConsumerCount(), (long)2000L, (long)100L);
        MqttClient producer = this.createPahoClient(this.protocol, "producer");
        producer.connect(this.getSslMqttConnectOptions());
        producer.publish(topic, body, 1, false);
        Assertions.assertTrue((boolean)latch.await(500L, TimeUnit.MILLISECONDS));
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = CertificateAuthenticationSslTests.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

