/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultipleProducersPagingTest
extends ActiveMQTestBase {
    private static final int CONSUMER_WAIT_TIME_MS = 250;
    private static final int PRODUCERS = 5;
    private static final long MESSAGES_PER_PRODUCER = 2000L;
    private static final long TOTAL_MSG = 10000L;
    private ExecutorService executor;
    private CountDownLatch runnersLatch;
    private CyclicBarrier barrierLatch;
    private AtomicLong msgReceived;
    private AtomicLong msgSent;
    private final Set<Connection> connections = new HashSet<Connection>();
    private ActiveMQServer server;
    private ConnectionFactory cf;
    private Queue queue;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.server = this.createServer((Configuration)this.createBasicConfig().setPersistenceEnabled(false).setAddressSettings(Collections.singletonMap("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setPageSizeBytes(50000).setMaxSizeBytes(404850L))).setAcceptorConfigurations(Collections.singleton(new TransportConfiguration(NettyAcceptorFactory.class.getName()))));
        this.server.start();
        this.cf = ActiveMQJMSClient.createConnectionFactory((String)"tcp://127.0.0.1:61616", (String)"cf");
        this.queue = ActiveMQJMSClient.createQueue((String)"simple");
        this.barrierLatch = new CyclicBarrier(6);
        this.runnersLatch = new CountDownLatch(6);
        this.msgReceived = new AtomicLong(0L);
        this.msgSent = new AtomicLong(0L);
    }

    @Test
    public void testQueue() throws InterruptedException {
        this.executor.execute(new ConsumerRun());
        for (int i = 0; i < 5; ++i) {
            this.executor.execute(new ProducerRun());
        }
        Assertions.assertTrue((boolean)this.runnersLatch.await(1L, TimeUnit.MINUTES), (String)"must take less than a minute to run");
        Assertions.assertEquals((long)10000L, (long)this.msgSent.longValue(), (String)"number sent");
        Assertions.assertEquals((long)10000L, (long)this.msgReceived.longValue(), (String)"number received");
    }

    private synchronized Session createSession() throws JMSException {
        Connection connection = this.cf.createConnection();
        this.connections.add(connection);
        connection.start();
        return connection.createSession(false, 1);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.executor.shutdown();
        for (Connection conn : this.connections) {
            conn.close();
        }
        this.connections.clear();
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    final class ConsumerRun
    implements Runnable {
        ConsumerRun() {
        }

        @Override
        public void run() {
            try {
                Message msg;
                Session session = MultipleProducersPagingTest.this.createSession();
                MessageConsumer consumer = session.createConsumer((Destination)MultipleProducersPagingTest.this.queue);
                MultipleProducersPagingTest.this.barrierLatch.await();
                while ((msg = consumer.receive(250L)) != null) {
                    MultipleProducersPagingTest.this.msgReceived.incrementAndGet();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                MultipleProducersPagingTest.this.runnersLatch.countDown();
            }
        }
    }

    final class ProducerRun
    implements Runnable {
        ProducerRun() {
        }

        @Override
        public void run() {
            try {
                Session session = MultipleProducersPagingTest.this.createSession();
                MessageProducer producer = session.createProducer((Destination)MultipleProducersPagingTest.this.queue);
                MultipleProducersPagingTest.this.barrierLatch.await();
                int i = 0;
                while ((long)i < 2000L) {
                    producer.send((Message)session.createTextMessage(this.hashCode() + " counter " + i));
                    MultipleProducersPagingTest.this.msgSent.incrementAndGet();
                    ++i;
                }
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
            finally {
                MultipleProducersPagingTest.this.runnersLatch.countDown();
            }
        }
    }
}

