/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.utils.RandomUtil;

final class SimpleClient {
    SimpleClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            if (args.length != 1) {
                throw new Exception("require 1 argument: connector factory class name");
            }
            String connectorFactoryClassName = args[0];
            String queueName = RandomUtil.randomString();
            String messageText = RandomUtil.randomString();
            try (ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryClassName)}).setReconnectAttempts(1).setInitialConnectAttempts(1);){
                ClientSessionFactory sf = locator.createSessionFactory();
                ClientSession session = sf.createSession(false, true, true);
                session.createQueue(QueueConfiguration.of((String)queueName).setDurable(Boolean.valueOf(false)));
                ClientProducer producer = session.createProducer(queueName);
                ClientConsumer consumer = session.createConsumer(queueName);
                ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
                message.getBodyBuffer().writeString(messageText);
                producer.send((Message)message);
                session.start();
                ClientMessage receivedMsg = consumer.receive(5000L);
                if (receivedMsg == null) {
                    throw new Exception("did not receive the message");
                }
                String text = receivedMsg.getBodyBuffer().readString();
                if (text == null || !text.equals(messageText)) {
                    throw new Exception("received " + text + ", was expecting " + messageText);
                }
                consumer.close();
                session.deleteQueue(queueName);
                session.close();
                sf.close();
                System.out.println("OK");
            }
        }
        catch (Throwable t) {
            StackTraceElement[] stackTrace;
            t.printStackTrace(System.out);
            String allStack = t.getMessage() + "|";
            for (StackTraceElement stackTraceElement : stackTrace = t.getStackTrace()) {
                allStack = allStack + stackTraceElement.toString() + "|";
            }
            System.out.println(allStack);
            System.exit(1);
        }
    }
}

