/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanResource;
import org.jboss.as.platform.mbean.BufferPoolMXBeanResource;
import org.jboss.as.platform.mbean.GarbageCollectorMXBeanResource;
import org.jboss.as.platform.mbean.LeafPlatformMBeanResource;
import org.jboss.as.platform.mbean.MemoryManagerMXBeanResource;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanResource;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;

public class RootPlatformMBeanResource
extends AbstractPlatformMBeanResource {
    public RootPlatformMBeanResource() {
        super(PlatformMBeanConstants.ROOT_PATH);
    }

    public Set<String> getChildTypes() {
        return Collections.singleton("type");
    }

    @Override
    Set<String> getChildrenNames() {
        return new LinkedHashSet<String>(PlatformMBeanConstants.BASE_TYPES);
    }

    @Override
    Resource.ResourceEntry getChildEntry(String name) {
        if ("class-loading".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.CLASS_LOADING_PATH);
        }
        if ("compilation".equals(name) && ManagementFactory.getCompilationMXBean() != null) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.COMPILATION_PATH);
        }
        if ("garbage-collector".equals(name)) {
            return new GarbageCollectorMXBeanResource();
        }
        if ("memory".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.MEMORY_PATH);
        }
        if ("memory-manager".equals(name)) {
            return new MemoryManagerMXBeanResource();
        }
        if ("memory-pool".equals(name)) {
            return new MemoryPoolMXBeanResource();
        }
        if ("operating-system".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.OPERATING_SYSTEM_PATH);
        }
        if ("runtime".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.RUNTIME_PATH);
        }
        if ("threading".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.THREADING_PATH);
        }
        if ("buffer-pool".equals(name)) {
            return new BufferPoolMXBeanResource();
        }
        if ("logging".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.LOGGING_PATH);
        }
        if ("platform-logging".equals(name)) {
            return new LeafPlatformMBeanResource(PlatformMBeanConstants.PLATFORM_LOGGING_PATH);
        }
        return null;
    }
}

