/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.subsystem.resource.executor.Metric;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CacheContainerMetric implements Metric<EmbeddedCacheManager>
{
    CACHE_MANAGER_STATUS("cache-manager-status", ModelType.STRING){

        public ModelNode execute(EmbeddedCacheManager manager) {
            return new ModelNode(manager.getStatus().toString());
        }
    }
    ,
    CLUSTER_NAME("cluster-name", ModelType.STRING){

        public ModelNode execute(EmbeddedCacheManager manager) {
            String clusterName = manager.getClusterName();
            return clusterName != null ? new ModelNode(clusterName) : null;
        }
    }
    ,
    COORDINATOR_ADDRESS("coordinator-address", ModelType.STRING){

        public ModelNode execute(EmbeddedCacheManager manager) {
            Address address = manager.getCoordinator();
            return address != null ? new ModelNode(address.toString()) : null;
        }
    }
    ,
    IS_COORDINATOR("is-coordinator", ModelType.BOOLEAN){

        public ModelNode execute(EmbeddedCacheManager manager) {
            return new ModelNode(manager.isCoordinator());
        }
    }
    ,
    LOCAL_ADDRESS("local-address", ModelType.STRING){

        public ModelNode execute(EmbeddedCacheManager manager) {
            Address address = manager.getAddress();
            return address != null ? new ModelNode(address.toString()) : null;
        }
    };

    private final AttributeDefinition definition;

    private CacheContainerMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.GAUGE_METRIC})).setStorageRuntime()).build();
    }

    public AttributeDefinition get() {
        return this.definition;
    }
}

