/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.ee.concurrent.ControlPointUtils;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStats;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStatsImpl30;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.SecurityIdentityUtils;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.WildFlyManagedExecutorService;
import org.jboss.as.ee.concurrent.WildFlyManagedThreadFactory;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.extension.requestcontroller.ControlPoint;

public class ManagedExecutorServiceImpl
extends org.glassfish.enterprise.concurrent.ManagedExecutorServiceImpl
implements WildFlyManagedExecutorService {
    private final ControlPoint controlPoint;
    private final ProcessStateNotifier processStateNotifier;
    private final ManagedExecutorRuntimeStats runtimeStats;

    public ManagedExecutorServiceImpl(String name, WildFlyManagedThreadFactory managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, WildFlyContextService contextService, WildFlyManagedExecutorService.RejectPolicy rejectPolicy, BlockingQueue<Runnable> queue, ControlPoint controlPoint, ProcessStateNotifier processStateNotifier) {
        super(name, (org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl)((ManagedThreadFactoryImpl)managedThreadFactory), hungTaskThreshold, longRunningTasks, corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, (ContextServiceImpl)contextService, ManagedExecutorServiceImpl.convertRejectPolicy(rejectPolicy), queue);
        this.controlPoint = controlPoint;
        this.processStateNotifier = processStateNotifier;
        this.runtimeStats = new ManagedExecutorRuntimeStatsImpl30(this);
    }

    public ManagedExecutorServiceImpl(String name, WildFlyManagedThreadFactory managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, int queueCapacity, WildFlyContextService contextService, WildFlyManagedExecutorService.RejectPolicy rejectPolicy, ControlPoint controlPoint, ProcessStateNotifier processStateNotifier) {
        super(name, (org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl)((ManagedThreadFactoryImpl)managedThreadFactory), hungTaskThreshold, longRunningTasks, corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, queueCapacity, (ContextServiceImpl)contextService, ManagedExecutorServiceImpl.convertRejectPolicy(rejectPolicy));
        this.controlPoint = controlPoint;
        this.processStateNotifier = processStateNotifier;
        this.runtimeStats = new ManagedExecutorRuntimeStatsImpl30(this);
    }

    public static AbstractManagedExecutorService.RejectPolicy convertRejectPolicy(WildFlyManagedExecutorService.RejectPolicy rejectPolicy) {
        return rejectPolicy != null ? AbstractManagedExecutorService.RejectPolicy.valueOf((String)rejectPolicy.toString()) : null;
    }

    public WildFlyManagedThreadFactory getWildFlyManagedThreadFactory() {
        return (WildFlyManagedThreadFactory)this.getManagedThreadFactory();
    }

    public <T> Future<T> submit(Callable<T> task) {
        Callable callable = ControlPointUtils.doWrap(task, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier);
        try {
            return super.submit(SecurityIdentityUtils.doIdentityWrap((Callable)callable));
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    public <T> Future<T> submit(Runnable task, T result) {
        Runnable runnable = ControlPointUtils.doWrap((Runnable)task, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier);
        try {
            return super.submit(SecurityIdentityUtils.doIdentityWrap((Runnable)runnable), result);
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    public Future<?> submit(Runnable task) {
        Runnable runnable = ControlPointUtils.doWrap((Runnable)task, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier);
        try {
            return super.submit(SecurityIdentityUtils.doIdentityWrap((Runnable)runnable));
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    public void execute(Runnable command) {
        Runnable runnable = ControlPointUtils.doWrap((Runnable)command, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier);
        try {
            super.execute(SecurityIdentityUtils.doIdentityWrap((Runnable)runnable));
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return (ThreadPoolExecutor)super.getThreadPoolExecutor();
    }

    public ManagedExecutorRuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public void terminateHungTasks() {
        String executorName = ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.getName();
        EeLogger.ROOT_LOGGER.debugf("Cancelling %s hung tasks...", (Object)executorName);
        Collection hungThreads = this.getHungThreads();
        if (hungThreads != null) {
            for (AbstractManagedThread t : hungThreads) {
                String taskIdentityName = t.getTaskIdentityName();
                try {
                    if (!(t instanceof ManagedThreadFactoryImpl.ManagedThread)) continue;
                    if (((ManagedThreadFactoryImpl.ManagedThread)t).cancelTask()) {
                        EeLogger.ROOT_LOGGER.hungTaskCancelled(executorName, taskIdentityName);
                        continue;
                    }
                    EeLogger.ROOT_LOGGER.hungTaskNotCancelled(executorName, taskIdentityName);
                }
                catch (Throwable throwable) {
                    EeLogger.ROOT_LOGGER.huntTaskTerminationFailure(throwable, executorName, taskIdentityName);
                }
            }
        }
    }
}

