/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.batch;

import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SimpleBatch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.function.Supplier;

public interface Batch
extends AutoCloseable {
    public static final Batch CLOSED = new SimpleBatch(false);

    public SuspendedBatch suspend();

    default public BatchContext<SuspendedBatch> suspendWithContext() {
        final SuspendedBatch suspended = this.suspend();
        return new BatchContext<SuspendedBatch>(){

            @Override
            public SuspendedBatch get() {
                return suspended;
            }

            public void close() {
                suspended.resume();
            }
        };
    }

    public void discard();

    public boolean isActive();

    public boolean isDiscarding();

    public boolean isClosed();

    @Override
    public void close();

    public static interface Factory
    extends Supplier<Batch> {
        public static final Factory SIMPLE = new Factory(){

            public Batch get() {
                return new SimpleBatch(true);
            }
        };
    }
}

