/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.protostream.reflect.Reflect;
import org.wildfly.clustering.marshalling.protostream.reflect.UnaryMemberMarshaller;

public class UnaryFieldMarshaller<T, F>
extends UnaryMemberMarshaller<T, Field, F> {
    public UnaryFieldMarshaller(Class<? extends T> targetClass, Class<F> fieldClass, Function<F, T> factory) {
        super(targetClass, Reflect::getValue, Reflect::findField, fieldClass, factory);
    }

    public UnaryFieldMarshaller(Class<? extends T> targetClass, Class<F> fieldClass) {
        this(targetClass, fieldClass, Reflect.getConstructor(targetClass, fieldClass));
    }

    private UnaryFieldMarshaller(Class<? extends T> targetClass, Class<F> fieldClass, final Constructor<? extends T> constructor) {
        this(targetClass, fieldClass, new Function<F, T>(){

            @Override
            public T apply(F value) {
                return Reflect.newInstance(constructor, value);
            }
        });
    }
}

