/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.infinispan.remote.AbstractRemoteCache;

public class ReadForUpdateRemoteCache<K, V>
extends AbstractRemoteCache<K, V> {
    public ReadForUpdateRemoteCache(RemoteCache<K, V> cache) {
        super(cache);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.withFlags(Flag.FORCE_RETURN_VALUE).computeIfPresentAsync(key, (BiFunction)org.wildfly.clustering.function.BiFunction.latter());
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        AtomicInteger remaining = new AtomicInteger(keys.size());
        ConcurrentHashMap entries = new ConcurrentHashMap();
        CompletableFuture result = new CompletableFuture();
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key;
            Object typedKey = key = iterator.next();
            this.getAsync(typedKey).whenComplete((value, exception) -> {
                if (exception != null) {
                    result.completeExceptionally((Throwable)exception);
                } else {
                    if (value != null) {
                        entries.put(typedKey, value);
                    }
                    if (remaining.decrementAndGet() == 0) {
                        result.complete(entries);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public RemoteCache<K, V> apply(RemoteCache<K, V> cache) {
        return new ReadForUpdateRemoteCache<K, V>(cache);
    }
}

