/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.security.manager.action.ReadEnvironmentPropertyAction;
import org.wildfly.security.manager.action.ReadPropertyAction;

public abstract class AbstractInstallationReporter
implements OperationStepHandler {
    protected static final String OPERATION_NAME = "report";

    private ModelNode createOSNode() throws OperationFailedException {
        String osName = this.getProperty("os.name");
        ModelNode os = new ModelNode();
        if (osName != null && osName.toLowerCase(Locale.ENGLISH).contains("linux")) {
            try {
                os.set(GnuLinuxDistribution.discover());
            }
            catch (IOException ex) {
                throw new OperationFailedException((Throwable)ex);
            }
        } else {
            os.set(osName);
        }
        return os;
    }

    private ModelNode createJVMNode() throws OperationFailedException {
        ModelNode jvm = new ModelNode().setEmptyObject();
        jvm.get("name").set(this.getProperty("java.vm.name"));
        jvm.get("java-version").set(this.getProperty("java.vm.specification.version"));
        jvm.get("jvm-version").set(this.getProperty("java.version"));
        jvm.get("jvm-vendor").set(this.getProperty("java.vm.vendor"));
        jvm.get("java-home").set(this.getProperty("java.home"));
        return jvm;
    }

    private ModelNode createCPUNode() throws OperationFailedException {
        ModelNode cpu = new ModelNode().setEmptyObject();
        cpu.get("host-cpu-arch").set(this.getProperty("os.arch"));
        cpu.get("host-core-count").set(ProcessorInfo.availableProcessors());
        return cpu;
    }

    protected ModelNode createProductNode(OperationContext context, InstallationConfiguration installation) throws OperationFailedException {
        String updateDate;
        String home;
        ModelNode root;
        assert (installation != null);
        assert (installation.getEnvironment() != null);
        ProcessEnvironment environment = installation.getEnvironment();
        ModelNode product = new ModelNode().setEmptyObject();
        product.get("host-name").set(installation.getHostName());
        product.get("instance-identifier").set(environment.getInstanceUuid().toString());
        PathAddress organizationAddress = PathAddress.EMPTY_ADDRESS;
        if (context.getProcessType().isHostController()) {
            organizationAddress = PathAddress.pathAddress((String)"host", (String)environment.getHostControllerName());
        }
        if (!(root = context.readResourceFromRoot(organizationAddress, false).getModel()).hasDefined("organization") && context.getProcessType().isHostController()) {
            root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).getModel();
        }
        if (root.hasDefined("organization")) {
            product.get("organization").set(root.get("organization").asString());
        } else if (root.hasDefined("domain-organization")) {
            product.get("organization").set(root.get("domain-organization").asString());
        }
        if (installation.getConfig() != null) {
            if (installation.getConfig().getProductName() != null) {
                product.get("product-name").set(installation.getConfig().getProductName());
            }
            if (installation.getConfig().getProductVersion() != null) {
                product.get("product-version").set(installation.getConfig().getProductVersion());
            }
            if (installation.getConfig().isProduct()) {
                product.get("product-community-identifier").set("Product");
            } else {
                product.get("product-community-identifier").set("Project");
            }
        }
        if (context.getProcessType() != ProcessType.SELF_CONTAINED && (home = installation.getInstallationDir()) != null && !home.isEmpty()) {
            product.get("product-home").set(home);
            String installationDate = installation.getInstallationDate();
            if (installationDate != null && !installationDate.isEmpty()) {
                product.get("installation-date").set(installationDate);
            }
        }
        if ((updateDate = installation.getLastUpdateDate()) != null && !updateDate.isEmpty()) {
            product.get("last-update-date").set(updateDate);
        }
        product.get("standalone-or-domain-identifier").set(context.getProcessType().name());
        product.get("host-operating-system").set(this.createOSNode());
        product.get("host-cpu").set(this.createCPUNode());
        product.get("jvm").set(this.createJVMNode());
        return product;
    }

    private String getProperty(String name) {
        return System.getSecurityManager() == null ? System.getProperty(name) : (String)AccessController.doPrivileged(new ReadPropertyAction(name));
    }

    private static enum GnuLinuxDistribution {
        ARCH("Arch", "/etc/arch-release"),
        CENTOS("CentOS", "/etc/redhat-release"),
        CENTOS_ALTERNATIVE("CentOS", "/etc/centos-release"),
        DEBIAN("Debian", "/etc/debian_version"),
        DEBIAN_ALTERNATIVE("Debian", "/etc/debian_release"),
        FEDORA("Fedora", "/etc/fedora-release"),
        GENTOO("Gentoo", "/etc/gentoo-release"),
        YELLOWDOG("YellowDog", "/etc/yellowdog-release"),
        KNOPPIX("Knoppix", "knoppix_version"),
        MAGEIA("Mageia", "/etc/mageia-release"),
        MANDRAKE("Mandrake", "/etc/mandrake-release"),
        MANDRIVA("Mandriva", "/etc/mandriva-release"),
        MANDRIVA_ALTERNATIVE("Mandriva", "/etc/version"),
        MINT("LinuxMint", "/etc/lsb-release"),
        PLD("PLD", "/etc/pld-release"),
        REDHAT("Red Hat", "/etc/redhat-release"),
        SLACKWARE("Slackware", "/etc/slackware-version"),
        SLACKWARE_ALTERNATIVE("Slackware", "/etc/slackware-release"),
        SUSE("SUSE", "/etc/SuSE-release"),
        OPEN_SUSE("openSUSE", "/etc/os-release"),
        SUSE_ALTERNATIVE("SUSE", "/etc/os-release"),
        UBUNTU("Ubuntu", "/etc/lsb-release"),
        PUPPY("Puppy", "/etc/puppyversion"),
        DEFAULT("Linux", "/etc/os-release");

        private static final GnuLinuxDistribution[] ALL;
        private final String distributionName;
        private final Path releasePath;

        private GnuLinuxDistribution(String distributionName, String releasePath) {
            this.releasePath = new File(releasePath).toPath();
            this.distributionName = distributionName;
        }

        public static final String discover() throws IOException {
            for (GnuLinuxDistribution distribution : ALL) {
                if (!Files.exists(distribution.releasePath, new LinkOption[0])) continue;
                Properties lines = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(distribution.releasePath, StandardCharsets.UTF_8);){
                    lines.load(reader);
                    String name = lines.getProperty("DISTRIB_DESCRIPTION", lines.getProperty("PRETTY_NAME"));
                    if (name == null || name.isEmpty()) continue;
                    String string = name.replace('\"', ' ').trim();
                    return string;
                }
            }
            return GnuLinuxDistribution.DEFAULT.distributionName;
        }

        static {
            ALL = new GnuLinuxDistribution[]{CENTOS, CENTOS_ALTERNATIVE, MINT, UBUNTU, DEBIAN, FEDORA, GENTOO, KNOPPIX, MANDRAKE, MANDRIVA, PLD, REDHAT, SLACKWARE, SLACKWARE_ALTERNATIVE, SUSE, OPEN_SUSE, SUSE_ALTERNATIVE, YELLOWDOG, ARCH, DEBIAN_ALTERNATIVE, DEFAULT};
        }
    }

    protected static final class InstallationConfiguration {
        private final ProcessEnvironment environment;
        private final ProductConfig config;
        private final ModelNode patchingInfo;
        private final Path installationDir;

        public InstallationConfiguration(ProcessEnvironment environment, ProductConfig config, ModelNode patchingInfo, Path installationDir) {
            assert (environment != null);
            assert (config != null);
            assert (patchingInfo != null);
            assert (installationDir != null);
            this.environment = environment;
            this.config = config;
            this.patchingInfo = patchingInfo;
            this.installationDir = installationDir;
        }

        public String getInstallationDate() {
            return "";
        }

        ProcessEnvironment getEnvironment() {
            return this.environment;
        }

        ProductConfig getConfig() {
            return this.config;
        }

        String getInstallationDir() {
            if (Files.exists(this.installationDir, new LinkOption[0])) {
                return this.installationDir.toAbsolutePath().toString();
            }
            return "";
        }

        String getLastUpdateDate() {
            if (this.patchingInfo.isDefined()) {
                List result = Operations.readResult((ModelNode)this.patchingInfo).asList();
                for (ModelNode patchAtt : result) {
                    if (!patchAtt.has("applied-at")) continue;
                    return patchAtt.get("applied-at").asString();
                }
            }
            return null;
        }

        String getHostName() {
            String hostName = this.getEnv("HOSTNAME");
            if (!(hostName != null && !hostName.isEmpty() || (hostName = this.getEnv("COMPUTERNAME")) != null && !hostName.isEmpty() || (hostName = InetAddressUtil.getLocalHostName()) != null && !hostName.isEmpty())) {
                hostName = this.environment.getHostName();
            }
            return hostName;
        }

        private String getEnv(String name) {
            return System.getSecurityManager() == null ? System.getenv(name) : (String)AccessController.doPrivileged(new ReadEnvironmentPropertyAction(name));
        }
    }
}

