/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryExtractContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryRequestContext;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.query.spi.SimpleSearchResultTotal;

class Elasticsearch7SearchResultExtractor<H>
implements ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> {
    protected static final JsonObjectAccessor HITS_ACCESSOR = JsonAccessor.root().property("hits").asObject();
    private static final JsonAccessor<JsonArray> HITS_HITS_ACCESSOR = HITS_ACCESSOR.property("hits").asArray();
    private static final JsonAccessor<Long> HITS_TOTAL_ACCESSOR = HITS_ACCESSOR.property("total").property("value").asLong();
    private static final JsonAccessor<String> HITS_TOTAL_RELATION_ACCESSOR = HITS_ACCESSOR.property("total").property("relation").asString();
    private static final JsonObjectAccessor AGGREGATIONS_ACCESSOR = JsonAccessor.root().property("aggregations").asObject();
    private static final JsonAccessor<Integer> TOOK_ACCESSOR = JsonAccessor.root().property("took").asInteger();
    private static final JsonAccessor<Boolean> TIMED_OUT_ACCESSOR = JsonAccessor.root().property("timed_out").asBoolean();
    private static final JsonAccessor<String> SCROLL_ID_ACCESSOR = JsonAccessor.root().property("_scroll_id").asString();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private static final String HITS_TOTAL_RELATION_EXACT_VALUE = "eq";
    private final ElasticsearchSearchQueryRequestContext requestContext;
    private final ElasticsearchSearchProjection.Extractor<?, H> rootExtractor;
    private final Map<AggregationKey<?>, ElasticsearchSearchAggregation.Extractor<?>> aggregations;

    Elasticsearch7SearchResultExtractor(ElasticsearchSearchQueryRequestContext requestContext, ElasticsearchSearchProjection.Extractor<?, H> rootExtractor, Map<AggregationKey<?>, ElasticsearchSearchAggregation.Extractor<?>> aggregations) {
        this.requestContext = requestContext;
        this.rootExtractor = rootExtractor;
        this.aggregations = aggregations;
    }

    @Override
    public ElasticsearchLoadableSearchResult<H> extract(JsonObject responseBody, Deadline deadline) {
        ElasticsearchSearchQueryExtractContext extractContext = this.requestContext.createExtractContext(responseBody);
        Integer took = TOOK_ACCESSOR.get(responseBody).get();
        boolean timedOut = TIMED_OUT_ACCESSOR.get(responseBody).get();
        SearchResultTotal total = this.extractTotal(responseBody);
        if (timedOut) {
            total = SimpleSearchResultTotal.lowerBound((long)total.hitCountLowerBound());
        }
        List<Object> extractedHits = total.isHitCountLowerBound() || total.hitCount() > 0L ? this.extractHits(extractContext) : Collections.emptyList();
        Map extractedAggregations = this.aggregations.isEmpty() ? Collections.emptyMap() : this.extractAggregations(extractContext, responseBody);
        String scrollId = this.extractScrollId(responseBody);
        return new ElasticsearchLoadableSearchResult<H>(extractContext, this.rootExtractor, total, extractedHits, extractedAggregations, took, timedOut, scrollId, deadline);
    }

    protected SearchResultTotal extractTotal(JsonObject responseBody) {
        Long hitsTotal = HITS_TOTAL_ACCESSOR.get(responseBody).orElse(0L);
        Optional<String> hitsTotalRelation = HITS_TOTAL_RELATION_ACCESSOR.get(responseBody);
        boolean exact = hitsTotalRelation.isPresent() && HITS_TOTAL_RELATION_EXACT_VALUE.equals(hitsTotalRelation.get());
        return SimpleSearchResultTotal.of((long)hitsTotal, (boolean)exact);
    }

    private List<Object> extractHits(ElasticsearchSearchQueryExtractContext extractContext) {
        JsonObject responseBody = extractContext.getResponseBody();
        ProjectionHitMapper<?> hitMapper = extractContext.getProjectionHitMapper();
        JsonArray jsonHits = HITS_HITS_ACCESSOR.get(responseBody).orElseGet(JsonArray::new);
        ProjectionExtractContext projectionExtractContext = extractContext.createProjectionExtractContext();
        ArrayList<Object> extractedData = new ArrayList<Object>(jsonHits.size());
        for (JsonElement hit : jsonHits) {
            JsonObject hitObject = hit.getAsJsonObject();
            JsonObject source = HIT_SOURCE_ACCESSOR.get(hitObject).orElse(null);
            extractedData.add(this.rootExtractor.extract(hitMapper, hitObject, source, projectionExtractContext));
        }
        return extractedData;
    }

    private Map<AggregationKey<?>, ?> extractAggregations(ElasticsearchSearchQueryExtractContext extractContext, JsonObject responseBody) {
        JsonObject jsonAggregations = AGGREGATIONS_ACCESSOR.get(responseBody).orElseGet(JsonObject::new);
        LinkedHashMap extractedMap = new LinkedHashMap();
        for (Map.Entry<AggregationKey<?>, ElasticsearchSearchAggregation.Extractor<?>> entry : this.aggregations.entrySet()) {
            AggregationKey<?> key = entry.getKey();
            ElasticsearchSearchAggregation.Extractor<?> aggregation = entry.getValue();
            Object extracted = aggregation.extract(jsonAggregations.getAsJsonObject(key.name()), extractContext);
            extractedMap.put(key, extracted);
        }
        return extractedMap;
    }

    protected String extractScrollId(JsonObject responseBody) {
        return SCROLL_ID_ACCESSOR.get(responseBody).orElse(null);
    }
}

