/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import java.util.function.Function;
import javax.naming.Context;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.naming.RequestType;
import org.wildfly.httpclient.naming.ServerHandlers;

public class HttpRemoteNamingService {
    private final HttpServiceConfig config;
    private final ServerHandlers serverHandlers;

    public HttpRemoteNamingService(Context localContext, Function<String, Boolean> classResolverFilter) {
        this(HttpServiceConfig.getInstance(), localContext, classResolverFilter);
    }

    private HttpRemoteNamingService(HttpServiceConfig config, Context localContext, Function<String, Boolean> classResolverFilter) {
        this.config = config;
        this.serverHandlers = ServerHandlers.newInstance(config, localContext, classResolverFilter);
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        for (RequestType requestType : RequestType.values()) {
            this.registerHandler(routingHandler, requestType);
        }
        return this.config.wrap((HttpHandler)new BlockingHandler((HttpHandler)new ElytronIdentityHandler((HttpHandler)routingHandler)));
    }

    private void registerHandler(RoutingHandler routingHandler, RequestType requestType) {
        String nameParamPathSuffix = "/{name}";
        routingHandler.add(requestType.getMethod(), requestType.getPath() + "/{name}", this.serverHandlers.handlerOf(requestType));
    }
}

