/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.service.ServiceInstaller;

public class ProvidedBinaryServiceInstallerProvider<P extends Function<BinaryServiceConfiguration, Iterable<ServiceInstaller>>>
implements Function<BinaryServiceConfiguration, Iterable<ServiceInstaller>> {
    private final Class<P> providerType;
    private final ClassLoader loader;

    public ProvidedBinaryServiceInstallerProvider(Class<P> providerType, ClassLoader loader) {
        this.providerType = providerType;
        this.loader = loader;
    }

    @Override
    public Iterable<ServiceInstaller> apply(final BinaryServiceConfiguration configuration) {
        final Class<P> providerType = this.providerType;
        final ClassLoader loader = this.loader;
        return new Iterable<ServiceInstaller>(){

            @Override
            public Iterator<ServiceInstaller> iterator() {
                return new Iterator<ServiceInstaller>(){
                    private final Iterator<P> providers;
                    private Iterator<ServiceInstaller> installers;
                    {
                        this.providers = ServiceLoader.load(providerType, loader).iterator();
                        this.installers = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.providers.hasNext() || this.installers.hasNext();
                    }

                    @Override
                    public ServiceInstaller next() {
                        while (!this.installers.hasNext()) {
                            this.installers = ((Iterable)((Function)this.providers.next()).apply(configuration)).iterator();
                        }
                        return this.installers.next();
                    }
                };
            }
        };
    }
}

