/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.Closeable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.jgroups.Address;
import org.jgroups.blocks.cs.Client;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpConnection;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Util;

public class TcpClient
extends TcpBaseServer
implements Client,
ConnectionListener {
    protected Address remote_addr;
    protected TcpConnection conn;

    public TcpClient(IpAddress bind_addr, IpAddress server_addr) {
        this(bind_addr != null ? bind_addr.getIpAddress() : null, bind_addr != null ? bind_addr.getPort() : 0, server_addr != null ? server_addr.getIpAddress() : null, server_addr != null ? server_addr.getPort() : 0);
    }

    public TcpClient(InetAddress bind_addr, int bind_port, InetAddress server_addr, int server_port) {
        super(new DefaultThreadFactory("tcp", false), new DefaultSocketFactory(), 0);
        this.clientBindAddress(bind_addr).clientBindPort(bind_port);
        this.remote_addr = new IpAddress(server_addr, server_port);
    }

    @Override
    public Address remoteAddress() {
        return this.remote_addr;
    }

    public TcpClient remoteAddress(IpAddress addr) {
        this.remote_addr = addr;
        return this;
    }

    @Override
    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    @Override
    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.doStart();
            }
            catch (Exception ex) {
                this.stop();
                throw ex;
            }
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            Util.close((Closeable)this.conn);
            super.stop();
        }
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        this.send(data, offset, length);
    }

    @Override
    public void send(Address dest, ByteBuffer data) throws Exception {
        this.send(data);
    }

    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        if (this.conn == null) {
            throw new IllegalStateException("connection to server " + this.remote_addr + " doesn't exist (has start() been called?)");
        }
        this.conn.send(data, offset, length);
    }

    @Override
    public void send(ByteBuffer data) throws Exception {
        if (this.conn == null) {
            throw new IllegalStateException("connection to server " + this.remote_addr + " doesn't exist (has start() been called?)");
        }
        this.conn.send(data);
    }

    @Override
    public void connectionClosed(Connection conn) {
        this.stop();
    }

    @Override
    public String toString() {
        if (this.conn == null || !this.conn.isConnected()) {
            return String.format("%s -> %s [not connected]", this.localAddress(), this.remoteAddress());
        }
        return String.format("%s", this.conn);
    }

    protected void doStart() throws Exception {
        super.start();
        this.conn = this.createConnection(this.remote_addr);
        this.addConnectionListener(this);
        this.conn.connect(this.remote_addr, false);
        this.local_addr = this.conn.localAddress();
        if (this.use_peer_connections) {
            this.conn.sendLocalAddress(this.local_addr);
        }
        this.notifyConnectionEstablished(this.conn);
        this.conn.start();
    }
}

