/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.fallback.FallbackEvents;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.fallback.FallbackLogger;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Preconditions;

public class Fallback<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final String description;
    private final FallbackFunction<V> fallback;
    private final ExceptionDecision exceptionDecision;

    public Fallback(FaultToleranceStrategy<V> delegate, String description, FallbackFunction<V> fallback, ExceptionDecision exceptionDecision) {
        this.delegate = Preconditions.checkNotNull(delegate, "Fallback delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Fallback description must be set");
        this.fallback = Preconditions.checkNotNull(fallback, "Fallback function must be set");
        this.exceptionDecision = Preconditions.checkNotNull(exceptionDecision, "Exception decision must be set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        FallbackFunction<V> fallback = ctx.get(FallbackFunction.class, this.fallback);
        ExceptionDecision exceptionDecision = ctx.get(ExceptionDecision.class, this.exceptionDecision);
        if (fallback == FallbackFunction.IGNORE || exceptionDecision == ExceptionDecision.IGNORE) {
            return this.delegate.apply(ctx);
        }
        FallbackLogger.LOG.trace("Fallback started");
        try {
            Future<Object> originalResult;
            ctx.fireEvent(FallbackEvents.Defined.INSTANCE);
            Completer result = Completer.create();
            try {
                originalResult = this.delegate.apply(ctx);
            }
            catch (Exception e) {
                originalResult = Future.ofError(e);
            }
            originalResult.then((value, error) -> {
                if (error == null) {
                    result.complete(value);
                    return;
                }
                if (ctx.isSync()) {
                    if (error instanceof InterruptedException) {
                        result.completeWithError((Throwable)error);
                        return;
                    }
                    if (Thread.interrupted()) {
                        result.completeWithError(new InterruptedException());
                        return;
                    }
                }
                if (exceptionDecision.isConsideredExpected((Throwable)error)) {
                    result.completeWithError((Throwable)error);
                    return;
                }
                try {
                    FallbackLogger.LOG.debugf("%s invocation failed, invoking fallback", this.description);
                    ctx.fireEvent(FallbackEvents.Applied.INSTANCE);
                    ((Future)fallback.apply(new FailureContext((Throwable)error, ctx))).thenComplete(result);
                }
                catch (Exception e) {
                    result.completeWithError(e);
                }
            });
            Future future = result.future();
            return future;
        }
        finally {
            FallbackLogger.LOG.trace("Fallback finished");
        }
    }
}

