/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;

class MailSessionRemove
extends AbstractRemoveStepHandler {
    MailSessionRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            MailSessionRemove.removeRuntimeServices(context, model);
        } else {
            context.reloadRequired();
        }
    }

    static void removeSessionProviderService(OperationContext context, ModelNode model) {
        MailSessionRemove.removeSessionProviderService(context, context.getCurrentAddress(), model);
    }

    static void removeSessionProviderService(OperationContext context, PathAddress address, ModelNode model) {
        context.removeService(MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(address).append(new String[]{"provider"}));
    }

    static void removeBinderService(OperationContext context, ModelNode model) throws OperationFailedException {
        String jndiName = MailSessionAdd.getJndiName(model, context);
        context.removeService(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName());
    }

    static void removeRuntimeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        MailSessionRemove.removeSessionProviderService(context, model);
        context.removeService(MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()));
        MailSessionRemove.removeBinderService(context, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            MailSessionAdd.installRuntimeServices(context, Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)));
        } else {
            context.revertReloadRequired();
        }
    }
}

