/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.api;

import io.opentelemetry.api.OpenTelemetry;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import io.smallrye.opentelemetry.implementation.rest.OpenTelemetryClientFilter;
import io.smallrye.opentelemetry.implementation.rest.OpenTelemetryServerFilter;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;

public final class OpenTelemetryCdiExtension
implements Extension {
    private final boolean useServerConfig;
    private final WildFlyOpenTelemetryConfig config;

    public OpenTelemetryCdiExtension(boolean useServerConfig, Map<String, String> config) {
        this(useServerConfig, new WildFlyOpenTelemetryConfig(config, useServerConfig));
    }

    public OpenTelemetryCdiExtension(boolean useServerConfig, WildFlyOpenTelemetryConfig config) {
        this.useServerConfig = useServerConfig;
        this.config = config;
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(OpenTelemetryServerFilter.class), OpenTelemetryServerFilter.class.getName());
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(OpenTelemetryClientFilter.class), OpenTelemetryClientFilter.class.getName());
    }

    void forceEagerInstantiationOfOpenTelemetry(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        beanManager.createInstance().select(OpenTelemetry.class, new Annotation[0]).get();
    }

    public void registerOpenTelemetryBeans(@Observes AfterBeanDiscovery abd) {
        if (this.useServerConfig) {
            abd.addBean().scope(Singleton.class).addQualifier((Annotation)Default.Literal.INSTANCE).types(new Type[]{OpenTelemetryConfig.class}).createWith(e -> this.config);
        }
    }
}

