/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.reply;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.EmitterType;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.reply.CorrelationId;
import io.smallrye.reactive.messaging.kafka.reply.PendingReply;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.microprofile.reactive.messaging.Message;

@Experimental(value="Experimental API")
public interface KafkaRequestReply<Req, Rep>
extends EmitterType {
    public static final String DEFAULT_REPLY_CORRELATION_ID_HEADER = "REPLY_CORRELATION_ID";
    public static final String REPLY_CORRELATION_ID_HEADER_KEY = "reply.correlation-id.header";
    public static final String DEFAULT_REPLY_TOPIC_HEADER = "REPLY_TOPIC";
    public static final String REPLY_TOPIC_HEADER_KEY = "reply.topic.header";
    public static final String DEFAULT_REPLY_PARTITION_HEADER = "REPLY_PARTITION";
    public static final String REPLY_PARTITION_HEADER_KEY = "reply.partition.header";
    public static final String DEFAULT_REPLIES_TOPIC_SUFFIX = "-replies";
    public static final String REPLY_TOPIC_KEY = "reply.topic";
    public static final String REPLY_PARTITION_KEY = "reply.partition";
    public static final String REPLY_TIMEOUT_KEY = "reply.timeout";
    public static final String REPLY_INITIAL_ASSIGNMENT_TIMEOUT_KEY = "reply.initial-assignment-timeout";
    public static final String REPLY_CORRELATION_ID_HANDLER_KEY = "reply.correlation-id.handler";
    public static final String DEFAULT_CORRELATION_ID_HANDLER = "uuid";
    public static final String REPLY_FAILURE_HANDLER_KEY = "reply.failure.handler";

    public Uni<Rep> request(Req var1);

    public Uni<Message<Rep>> request(Message<Req> var1);

    public Uni<Set<TopicPartition>> waitForAssignments();

    public Uni<Set<TopicPartition>> waitForAssignments(Collection<TopicPartition> var1);

    public Map<CorrelationId, PendingReply> getPendingReplies();

    public KafkaConsumer<?, Rep> getConsumer();

    public void complete();

    public static int replyPartitionFromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static byte[] replyPartitionToBytes(int partition) {
        return ByteBuffer.allocate(4).putInt(partition).array();
    }
}

