/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.TP;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.FastArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public abstract class BaseBundler
implements Bundler {
    protected final Map<Address, List<Message>> msgs = new HashMap<Address, List<Message>>(24);
    protected final Function<Address, List<Message>> FUNC = k -> new FastArray(32).increment(64);
    protected TP transport;
    protected MessageProcessingPolicy msg_processing_policy;
    protected final ReentrantLock lock = new ReentrantLock();
    protected long count;
    protected ByteArrayDataOutputStream output;
    protected MsgStats msg_stats;
    protected Log log;
    @Property(name="max_size", type=AttributeType.BYTES, description="Maximum number of bytes for messages to be queued until they are sent")
    protected int max_size = 64000;
    @Property(description="The max number of elements in a bundler if the bundler supports size limitations", type=AttributeType.SCALAR)
    protected int capacity = 16384;
    @ManagedAttribute(description="Time (us) to send the bundled messages")
    protected final AverageMinMax avg_send_time = (AverageMinMax)new AverageMinMax(1024).unit(TimeUnit.NANOSECONDS);

    @ManagedOperation(description="Prints the capacity of the buffers")
    public String printBuffers() {
        return this.msgs.entrySet().stream().map(e -> String.format("%s: %d", e.getKey(), ((FastArray)e.getValue()).capacity())).collect(Collectors.joining("\n"));
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public Bundler setCapacity(int c) {
        this.capacity = c;
        return this;
    }

    @Override
    public int getMaxSize() {
        return this.max_size;
    }

    @Override
    public Bundler setMaxSize(int s) {
        this.max_size = s;
        return this;
    }

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.msg_processing_policy = transport.msgProcessingPolicy();
        this.msg_stats = transport.getMessageStats();
        this.log = transport.getLog();
        this.output = new ByteArrayDataOutputStream(this.max_size + 5);
    }

    @Override
    public void resetStats() {
        this.avg_send_time.clear();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
    }

    @Override
    public void viewChange(View view) {
    }

    @Override
    @ManagedAttribute(description="The number of unsent messages in the bundler")
    public int size() {
        this.lock.lock();
        try {
            int n = this.msgs.values().stream().map(List::size).reduce(0, Integer::sum);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @ManagedAttribute(description="Size of the queue (if available")
    public int getQueueSize() {
        return -1;
    }

    protected void sendBundledMessages() {
        boolean stats_enabled = this.transport.statsEnabled();
        long start = stats_enabled ? System.nanoTime() : 0L;
        for (Map.Entry<Address, List<Message>> entry : this.msgs.entrySet()) {
            List<Message> list = entry.getValue();
            if (list.isEmpty()) continue;
            Address dst = entry.getKey();
            this.output.position(0);
            if (list.size() == 1) {
                this.sendSingle(dst, list.get(0), this.output);
            } else {
                this.sendMultiple(dst, list.get(0).src(), list, this.output);
            }
            list.clear();
        }
        this.count = 0L;
        if (stats_enabled) {
            long time = System.nanoTime() - start;
            this.avg_send_time.add(time);
        }
    }

    protected void sendSingle(Address dst, Message msg, ByteArrayDataOutputStream out) {
        if (dst == null) {
            this.sendSingleMessage(msg, out);
            this.loopbackUnlessDontLoopbackIsSet(msg);
        } else {
            boolean send_to_self;
            boolean bl = send_to_self = Objects.equals(this.transport.getAddress(), dst) || dst instanceof PhysicalAddress && dst.equals(this.transport.localPhysicalAddress());
            if (send_to_self) {
                this.loopbackUnlessDontLoopbackIsSet(msg);
            } else {
                this.sendSingleMessage(msg, out);
            }
        }
    }

    protected void sendMultiple(Address dst, Address sender, List<Message> list, ByteArrayDataOutputStream out) {
        if (dst == null) {
            this.sendMessageList(dst, sender, list, out);
            this.loopback(dst, this.transport.getAddress(), list, list.size());
        } else {
            boolean loopback;
            boolean bl = loopback = Objects.equals(this.transport.getAddress(), dst) || dst instanceof PhysicalAddress && dst.equals(this.transport.localPhysicalAddress());
            if (loopback) {
                this.loopback(dst, this.transport.getAddress(), list, list.size());
            } else {
                this.sendMessageList(dst, sender, list, out);
            }
        }
    }

    protected void sendMultiple(Address dst, Address sender, Message[] list, int len, ByteArrayDataOutputStream out) {
        if (dst == null) {
            this.sendMessageList(dst, sender, list, len, out);
            this.loopback(dst, this.transport.getAddress(), list, len);
        } else {
            boolean send_to_self;
            boolean bl = send_to_self = Objects.equals(this.transport.getAddress(), dst) || dst instanceof PhysicalAddress && dst.equals(this.transport.localPhysicalAddress());
            if (send_to_self) {
                this.loopback(dst, this.transport.getAddress(), list, len);
            } else {
                this.sendMessageList(dst, sender, list, len, out);
            }
        }
    }

    protected void loopbackUnlessDontLoopbackIsSet(Message msg) {
        if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
            return;
        }
        this.msg_stats.received(msg);
        this.msg_processing_policy.loopback(msg, msg.isFlagSet(Message.Flag.OOB));
    }

    protected void loopback(Address dest, Address sender, Iterable<Message> list, int size) {
        MessageBatch reg = null;
        MessageBatch oob = null;
        for (Message msg : list) {
            if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) continue;
            if (msg.isFlagSet(Message.Flag.OOB)) {
                if (oob == null) {
                    oob = new MessageBatch(dest, sender, this.transport.getClusterNameAscii(), dest == null, MessageBatch.Mode.OOB, size);
                }
                oob.add(msg);
                continue;
            }
            if (reg == null) {
                reg = new MessageBatch(dest, sender, this.transport.getClusterNameAscii(), dest == null, MessageBatch.Mode.REG, size);
            }
            reg.add(msg);
        }
        if (reg != null) {
            this.msg_stats.received(reg);
            this.msg_processing_policy.loopback(reg, false);
        }
        if (oob != null) {
            this.msg_stats.received(oob);
            this.msg_processing_policy.loopback(oob, true);
        }
    }

    protected void loopback(Address dest, Address sender, Message[] list, int len) {
        FastArray<Message> fa = new FastArray<Message>(list, len);
        this.loopback(dest, sender, fa, fa.size());
    }

    protected void sendSingleMessage(Message msg, ByteArrayDataOutputStream out) {
        Address dest = msg.getDest();
        try {
            Util.writeMessage(msg, out, dest == null);
            this.transport.doSend(out.buffer(), 0, out.position(), dest);
            this.transport.getMessageStats().incrNumSingleMsgsSent();
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.getAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void sendMessageList(Address dest, Address src, List<Message> list, ByteArrayDataOutputStream out) {
        try {
            Util.writeMessageList(dest, src, this.transport.cluster_name.chars(), list, (DataOutput)out, dest == null);
            this.transport.doSend(out.buffer(), 0, out.position(), dest);
            this.transport.getMessageStats().incrNumBatchesSent();
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("FailureSendingMsgBundle"), this.transport.getAddress(), e);
        }
    }

    protected void sendMessageList(Address dest, Address src, Message[] list, int len, ByteArrayDataOutputStream out) {
        try {
            Util.writeMessageList(dest, src, this.transport.cluster_name.chars(), list, 0, len, out, dest == null);
            this.transport.doSend(out.buffer(), 0, out.position(), dest);
            this.transport.getMessageStats().incrNumBatchesSent();
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("FailureSendingMsgBundle"), this.transport.getAddress(), e);
        }
    }

    protected void addMessage(Message msg, int size) {
        Address dest = msg.getDest();
        List<Message> tmp = this.msgs.computeIfAbsent(dest, this.FUNC);
        tmp.add(msg);
        this.count += (long)size;
    }
}

