/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class JDBC_PING2
extends FILE_PING {
    protected final Lock lock = new ReentrantLock();
    @Property(description="The JDBC connection URL", writable=false)
    protected String connection_url;
    @Property(description="The JDBC connection username", writable=false)
    protected String connection_username;
    @Property(description="The JDBC connection password", writable=false, exposeAsManagedAttribute=false)
    protected String connection_password;
    @Property(description="The JDBC connection driver name", writable=false)
    protected String connection_driver;
    @Property(description="If not null, this SQL statement will be performed at startup. Customize it to create the needed table. To allow for creation attempts, errors performing this statement will be logged but not considered fatal. To avoid any creation, set this to null.")
    protected String initialize_sql = "CREATE TABLE jgroups (address varchar(200) NOT NULL, name varchar(200), cluster varchar(200) NOT NULL, ip varchar(200) NOT NULL, coord boolean, PRIMARY KEY (address) )";
    @Property(description="Definition of a stored procedure which deletes an existing row and inserts a new one. Used only if non-null (as an optimization of calling delete, then insert (1 SQL statement instead of 2). Needs to accept address (varchar), name (varchar), cluster (varchar), ip (varchar) and coord (boolean")
    protected String insert_sp;
    @Property(description="Calls the insert_sp stored procedure. Not used if null.")
    protected String call_insert_sp;
    @Property(description="SQL used to insert a new row")
    protected String insert_single_sql = "INSERT INTO jgroups values (?, ?, ?, ?, ?)";
    @Property(description="SQL used to delete a row")
    protected String delete_single_sql = "DELETE FROM jgroups WHERE address=?";
    @Property(description="SQL to clear the table")
    protected String clear_sql = "DELETE from jgroups WHERE cluster=?";
    @Property(description="SQL used to fetch the data of all nodes")
    protected String select_all_pingdata_sql = "SELECT address, name, ip, coord FROM jgroups WHERE cluster=?";
    @Property(description="To use a DataSource registered in JNDI, specify the JNDI name here")
    protected String datasource_jndi_name;
    @Property(description="The fully qualified name of a class which implements a Function<JDBC_PING,DataSource>. If not null, this has precedence over datasource_jndi_name.")
    protected String datasource_injecter_class;
    protected DataSource dataSource;

    @Override
    protected void createRootDir() {
    }

    public JDBC_PING2 setDataSource(DataSource ds) {
        this.dataSource = ds;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getConnectionUrl() {
        return this.connection_url;
    }

    public JDBC_PING2 setConnectionUrl(String c) {
        this.connection_url = c;
        return this;
    }

    public String getConnectionUsername() {
        return this.connection_username;
    }

    public JDBC_PING2 setConnectionUsername(String c) {
        this.connection_username = c;
        return this;
    }

    public String getConnectionPassword() {
        return this.connection_password;
    }

    public JDBC_PING2 setConnectionPassword(String c) {
        this.connection_password = c;
        return this;
    }

    public String getConnectionDriver() {
        return this.connection_driver;
    }

    public JDBC_PING2 setConnectionDriver(String c) {
        this.connection_driver = c;
        return this;
    }

    public String getInitializeSql() {
        return this.initialize_sql;
    }

    public JDBC_PING2 setInitializeSql(String i) {
        this.initialize_sql = i;
        return this;
    }

    public String getInsertSingleSql() {
        return this.insert_single_sql;
    }

    public JDBC_PING2 setInsertSingleSql(String i) {
        this.insert_single_sql = i;
        return this;
    }

    public String getInsertSp() {
        return this.insert_sp;
    }

    public JDBC_PING2 setInsertSp(String sp) {
        this.insert_sp = sp;
        return this;
    }

    public String getCallInsertSp() {
        return this.call_insert_sp;
    }

    public JDBC_PING2 setCallInsertSp(String sp) {
        this.call_insert_sp = sp;
        return this;
    }

    public String getDeleteSingleSql() {
        return this.delete_single_sql;
    }

    public JDBC_PING2 setDeleteSingleSql(String d) {
        this.delete_single_sql = d;
        return this;
    }

    public String getClearSql() {
        return this.clear_sql;
    }

    public JDBC_PING2 setClearSql(String c) {
        this.clear_sql = c;
        return this;
    }

    public String getSelectAllPingdataSql() {
        return this.select_all_pingdata_sql;
    }

    public JDBC_PING2 setSelectAllPingdataSql(String s) {
        this.select_all_pingdata_sql = s;
        return this;
    }

    public String getDatasourceJndiName() {
        return this.datasource_jndi_name;
    }

    public JDBC_PING2 setDatasourceJndiName(String d) {
        this.datasource_jndi_name = d;
        return this;
    }

    public String getDatasourceInjecterClass() {
        return this.datasource_injecter_class;
    }

    public JDBC_PING2 setDatasourceInjecterClass(String d) {
        this.datasource_injecter_class = d;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.dataSource == null) {
            if (this.datasource_injecter_class != null) {
                this.dataSource = this.injectDataSource(this.datasource_injecter_class);
                if (this.dataSource == null) {
                    String m = String.format("datasource_injecter_class %s created null datasource", this.datasource_injecter_class);
                    throw new IllegalArgumentException(m);
                }
            } else if (this.datasource_jndi_name != null) {
                this.dataSource = this.getDataSourceFromJNDI(this.datasource_jndi_name.trim());
            } else {
                this.loadDriver();
            }
        }
        this.createSchema();
        this.createInsertStoredProcedure();
    }

    @ManagedOperation(description="Lists all rows in the database")
    public String dump(String cluster) throws Exception {
        List<PingData> list = this.readFromDB(cluster);
        return list.stream().map(pd -> String.format("%s", pd)).collect(Collectors.joining("\n"));
    }

    @Override
    protected void write(List<PingData> list, String clustername) {
        for (PingData data : list) {
            try {
                this.writeToDB(data, clustername);
            }
            catch (SQLException e) {
                this.log.error("%s: failed writing to DB: %s", this.local_addr, e);
            }
        }
        ++this.writes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToDB(PingData data, String clustername) throws SQLException {
        block19: {
            this.lock.lock();
            try (Connection connection = this.getConnection();){
                if (this.call_insert_sp != null && this.insert_sp != null) {
                    this.callInsertStoredProcedure(connection, data, clustername);
                    break block19;
                }
                boolean isAutocommit = connection.getAutoCommit();
                try {
                    if (isAutocommit) {
                        connection.setAutoCommit(false);
                    }
                    this.delete(connection, clustername, data.getAddress());
                    this.insert(connection, data, clustername);
                    if (isAutocommit) {
                        connection.commit();
                    }
                }
                catch (SQLException ex) {
                    if (isAutocommit) {
                        connection.rollback();
                    }
                    throw ex;
                }
                finally {
                    if (isAutocommit) {
                        connection.setAutoCommit(isAutocommit);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    protected void remove(String clustername, Address addr) {
        try {
            this.delete(clustername, addr);
        }
        catch (SQLException e) {
            this.log.error(String.format("%s: failed deleting %s from the table", this.local_addr, addr), e);
        }
    }

    @Override
    protected void removeAll(String clustername) {
        try {
            this.clearTable(clustername);
        }
        catch (Exception ex) {
            this.log.error(String.format("%s: failed clearing the table for cluster %s", this.local_addr, clustername), ex);
        }
    }

    @Override
    protected void readAll(List<Address> members, String cluster, Responses rsps) {
        try {
            List<PingData> list = this.readFromDB(cluster);
            for (PingData data : list) {
                Address addr = data.getAddress();
                if (data == null || members != null && !members.contains(addr)) continue;
                rsps.addResponse(data, false);
                if (this.local_addr == null || this.local_addr.equals(addr)) continue;
                this.addDiscoveryResponseToCaches(addr, data.getLogicalName(), data.getPhysicalAddr());
            }
        }
        catch (Exception e) {
            this.log.error(String.format("%s: failed reading from the DB", this.local_addr), e);
        }
    }

    /*
     * Exception decompiling
     */
    protected List<PingData> readFromDB(String cluster) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static PreparedStatement prepare(Connection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException x) {
            try {
                return conn.prepareStatement(sql);
            }
            catch (SQLException x2) {
                x.addSuppressed(x2);
                throw x;
            }
        }
    }

    protected void createSchema() {
        if (this.initialize_sql == null) {
            this.log.debug("%s: table creation step skipped: initialize_sql attribute is missing", this.local_addr);
            return;
        }
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(this.initialize_sql);){
            this.log.trace("%s: SQL for initializing schema: %s", this.local_addr, ps);
            ps.execute();
            this.log.debug("%s: table created for JDBC_PING discovery protocol", this.local_addr);
        }
        catch (SQLException e) {
            this.log.debug("%s: failed executing initialize_sql statement; not necessarily an error, we always attempt to create the schema. To suppress this message, set initialize_sql to null. Cause: %s", this.local_addr, e.getMessage());
        }
    }

    protected void createInsertStoredProcedure() throws SQLException {
        if (this.insert_sp == null) {
            return;
        }
        try (Connection conn = this.getConnection();){
            try (PreparedStatement ps = conn.prepareStatement(this.insert_sp);){
                this.log.trace("%s: attempting to create stored procedure %s", this.local_addr, this.insert_sp);
                ps.execute();
                this.log.debug("%s: successfully created stored procedure %s", this.local_addr, this.insert_sp);
            }
            catch (SQLException ex) {
                this.log.debug("%s: failed creating stored procedure %s: %s", this.local_addr, this.insert_sp, ex.getMessage());
            }
        }
    }

    protected void loadDriver() {
        JDBC_PING2.assertNonNull("connection_driver", this.connection_driver);
        this.log.debug("%s: loading JDBC driver %s", this.local_addr, this.connection_driver);
        try {
            Util.loadClass(this.connection_driver, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("JDBC driver could not be loaded: '%s'", this.connection_driver));
        }
    }

    protected DataSource injectDataSource(String ds_class) throws Exception {
        Class<?> cl = Util.loadClass(ds_class, Thread.currentThread().getContextClassLoader());
        Object obj = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        Function fun = (Function)obj;
        return (DataSource)fun.apply(this);
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource != null ? this.dataSource.getConnection() : DriverManager.getConnection(this.connection_url, this.connection_username, this.connection_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Connection connection, PingData data, String clustername) throws SQLException {
        this.lock.lock();
        try (PreparedStatement ps = connection.prepareStatement(this.insert_single_sql);){
            Address address = data.getAddress();
            String addr = Util.addressToString(address);
            String name = address instanceof SiteUUID ? ((SiteUUID)address).getName() : NameCache.get(address);
            PhysicalAddress ip_addr = data.getPhysicalAddr();
            String ip = ip_addr.toString();
            ps.setString(1, addr);
            ps.setString(2, name);
            ps.setString(3, clustername);
            ps.setString(4, ip);
            ps.setBoolean(5, data.isCoord());
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: SQL for insertion: %s", this.local_addr, ps);
            }
            ps.executeUpdate();
            this.log.debug("%s: inserted %s for cluster %s", this.local_addr, address, clustername);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callInsertStoredProcedure(Connection connection, PingData data, String clustername) throws SQLException {
        this.lock.lock();
        try (PreparedStatement ps = connection.prepareStatement(this.call_insert_sp);){
            Address address = data.getAddress();
            String addr = Util.addressToString(address);
            String name = address instanceof SiteUUID ? ((SiteUUID)address).getName() : NameCache.get(address);
            PhysicalAddress ip_addr = data.getPhysicalAddr();
            String ip = ip_addr.toString();
            ps.setString(1, addr);
            ps.setString(2, name);
            ps.setString(3, clustername);
            ps.setString(4, ip);
            ps.setBoolean(5, data.isCoord());
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: SQL for insertion: %s", this.local_addr, ps);
            }
            ps.executeUpdate();
            this.log.debug("%s: inserted %s for cluster %s", this.local_addr, address, clustername);
        }
        finally {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(Connection conn, String clustername, Address addressToDelete) throws SQLException {
        this.lock.lock();
        try (PreparedStatement ps = conn.prepareStatement(this.delete_single_sql);){
            String addr = Util.addressToString(addressToDelete);
            ps.setString(1, addr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: SQL for deletion: %s", this.local_addr, ps);
            }
            ps.executeUpdate();
            this.log.debug("%s: removed %s for cluster %s from database", this.local_addr, addressToDelete, clustername);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void delete(String clustername, Address addressToDelete) throws SQLException {
        try (Connection connection = this.getConnection();){
            this.delete(connection, clustername, addressToDelete);
        }
    }

    protected void clearTable(String clustername) throws SQLException {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(this.clear_sql);){
            if (this.clear_sql.indexOf(63) >= 0) {
                ps.setString(1, clustername);
            } else {
                this.log.debug("%s: please update your clear_sql to include the cluster parameter", this.local_addr);
            }
            ps.execute();
            this.log.debug("%s: cleared table for cluster %s", this.local_addr, clustername);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSource getDataSourceFromJNDI(String name) {
        DataSource dataSource;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object whatever = ctx.lookup(name);
            if (whatever == null) {
                throw new IllegalArgumentException("JNDI name " + name + " is not bound");
            }
            if (!(whatever instanceof DataSource)) {
                throw new IllegalArgumentException("JNDI name " + name + " was found but is not a DataSource");
            }
            DataSource data_source = (DataSource)whatever;
            this.log.debug("%s: datasource found via JNDI lookup via name: %s", this.local_addr, name);
            dataSource = data_source;
            if (ctx == null) return dataSource;
        }
        catch (NamingException e) {
            try {
                throw new IllegalArgumentException("Could not lookup datasource " + name, e);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException e2) {
                    this.log.warn("%s: failed to close naming context: %s", this.local_addr, e2);
                }
                throw throwable;
            }
        }
        try {
            ctx.close();
            return dataSource;
        }
        catch (NamingException e) {
            this.log.warn("%s: failed to close naming context: %s", this.local_addr, e);
        }
        return dataSource;
    }

    protected static void assertNonNull(String ... strings) {
        for (int i = 0; i < strings.length; i += 2) {
            String attr = strings[i];
            String val = strings[i + 1];
            if (val != null) continue;
            throw new IllegalArgumentException(String.format("%s must not be null", attr));
        }
    }

    public static void main(String[] args) throws Exception {
        String driver = "org.hsqldb.jdbcDriver";
        String user = "SA";
        String pwd2 = "";
        String conn = "jdbc:hsqldb:hsql://localhost/";
        String cluster = "draw";
        String select = "SELECT address, name, cluster, ip, coord FROM JGROUPS WHERE cluster=?";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-driver")) {
                driver = args[++i];
                continue;
            }
            if (args[i].equals("-conn")) {
                conn = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-pwd")) {
                pwd2 = args[++i];
                continue;
            }
            if (args[i].equals("-cluster")) {
                cluster = args[++i];
                continue;
            }
            if (args[i].equals("-select")) {
                select = args[++i];
                continue;
            }
            System.out.println("JDBC_PING2 [-driver driver] [-conn conn-url] [-user user] [-pwd password] [-cluster cluster-name] [-select select-stmt]");
            return;
        }
        Class.forName(driver);
        try (Connection c = DriverManager.getConnection(conn, user, pwd2);
             PreparedStatement ps = JDBC_PING2.prepare(c, select, 1003, 1008);){
            ps.setString(1, cluster);
            try (ResultSet resultSet = ps.executeQuery();){
                int index = 1;
                while (resultSet.next()) {
                    String uuid = resultSet.getString(1);
                    String name = resultSet.getString(2);
                    String cluster_name = resultSet.getString(3);
                    String ip = resultSet.getString(4);
                    boolean coord = resultSet.getBoolean(5);
                    System.out.printf("%d: %s, name=%s, ip=%s, %b (cluster=%s)\n", index++, uuid, name, ip, coord ? "coord" : "server", cluster_name);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

