/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class WeldDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String JAVAX_PERSISTENCE_API_ID = "jakarta.persistence.api";
    private static final String JBOSS_AS_WELD_ID = "org.jboss.as.weld";
    private static final String JBOSS_AS_WELD_EJB_ID = "org.jboss.as.weld.ejb";
    private static final String WELD_CORE_ID = "org.jboss.weld.core";
    private static final String WELD_API_ID = "org.jboss.weld.api";
    private static final String WELD_SPI_ID = "org.jboss.weld.spi";
    private static final String JAVAX_ENTERPRISE_API = "jakarta.enterprise.api";
    private static final String JAVAX_INJECT_API = "jakarta.inject.api";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_ENTERPRISE_API);
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_INJECT_API);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_PERSISTENCE_API_ID);
        this.addDependency(moduleSpecification, moduleLoader, WELD_CORE_ID);
        this.addDependency(moduleSpecification, moduleLoader, WELD_API_ID);
        this.addDependency(moduleSpecification, moduleLoader, WELD_SPI_ID);
        ModuleDependency weldSubsystemDependency = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JBOSS_AS_WELD_ID).build();
        weldSubsystemDependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
        weldSubsystemDependency.addImportFilter(PathFilters.is((String)"org/jboss/as/weld/injection"), true);
        weldSubsystemDependency.addImportFilter(PathFilters.acceptAll(), false);
        weldSubsystemDependency.addExportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(weldSubsystemDependency);
        ModuleDependency weldEjbDependency = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JBOSS_AS_WELD_EJB_ID).setOptional(true).build();
        weldEjbDependency.addImportFilter(PathFilters.is((String)"org/jboss/as/weld/ejb"), true);
        weldEjbDependency.addImportFilter(PathFilters.acceptAll(), false);
        moduleSpecification.addSystemDependency(weldEjbDependency);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String moduleIdentifier) {
        this.addDependency(moduleSpecification, moduleLoader, moduleIdentifier, false);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String moduleIdentifier, boolean optional) {
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)moduleIdentifier).setOptional(optional).setImportServices(true).build());
    }
}

