/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.resource.ResourceModelResolver;

public interface CacheConfigurationAttributeGroup
extends ResourceModelResolver<BinaryServiceConfiguration> {
    public AttributeDefinition getContainerAttribute();

    public AttributeDefinition getCacheAttribute();

    default public Collection<AttributeDefinition> getAttributes() {
        return List.of(this.getContainerAttribute(), this.getCacheAttribute());
    }

    default public BinaryServiceConfiguration resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String containerName = this.getContainerAttribute().resolveModelAttribute(context, model).asString();
        String cacheName = this.getCacheAttribute().resolveModelAttribute(context, model).asStringOrNull();
        return BinaryServiceConfiguration.of(containerName, cacheName);
    }
}

