/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceRegistration;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.singleton.SingletonSubsystemResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.singleton.election.OutboundSocketBindingPreference;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceListAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class ElectionPolicyResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
ResourceModelResolver<SingletonElectionPolicy>,
UnaryOperator<ResourceDescriptor.Builder> {
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonElectionPolicy.SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    private static final AttributeMarshaller PREFERENCES_MARSHALLER = new DefaultAttributeMarshaller(){

        public boolean isMarshallableAsElement() {
            return true;
        }

        protected String asString(ModelNode value) {
            return value.asListOrEmpty().stream().map(ModelNode::asString).collect(Collectors.joining(" "));
        }
    };
    private static final AttributeParser PREFERENCES_PARSER = new AttributeParsers.AttributeElementParser(){

        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            ModelNode list = operation.get(attribute.getName()).setEmptyList();
            for (String value : reader.getElementText().split("\\s+")) {
                list.add(new ModelNode(value));
            }
        }
    };
    private static final String NAME_PREFERENCES_NAME = "name-preferences";
    static final CapabilityReferenceListAttributeDefinition<OutboundSocketBinding> SOCKET_BINDING_PREFERENCES = ((CapabilityReferenceListAttributeDefinition.Builder)((CapabilityReferenceListAttributeDefinition.Builder)((CapabilityReferenceListAttributeDefinition.Builder)((CapabilityReferenceListAttributeDefinition.Builder)new CapabilityReferenceListAttributeDefinition.Builder("socket-binding-preferences", CapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR).build()).setRequired(false)).setAlternatives(new String[]{"name-preferences"})).setAttributeMarshaller(PREFERENCES_MARSHALLER)).setAttributeParser(PREFERENCES_PARSER)).build();
    static final AttributeDefinition NAME_PREFERENCES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("name-preferences").setAllowExpression(true)).setRequired(false)).setAlternatives(new String[]{SOCKET_BINDING_PREFERENCES.getName()})).setAttributeMarshaller(PREFERENCES_MARSHALLER)).setAttributeParser(PREFERENCES_PARSER)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private final ResourceRegistration registration;

    ElectionPolicyResourceDefinitionRegistrar(ResourceRegistration registration) {
        this.registration = registration;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addCapability(CAPABILITY)).addAttributes(List.of(SOCKET_BINDING_PREFERENCES, NAME_PREFERENCES))).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = SingletonSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.registration.getPathElement(), ElectionPolicyResourceRegistration.WILDCARD.getPathElement());
        ResourceDescriptor descriptor = this.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)resolver)).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List namePreferences = NAME_PREFERENCES.resolveModelAttribute(context, model).asListOrEmpty();
        List socketBindingPreferences = SOCKET_BINDING_PREFERENCES.resolveModelAttribute(context, model).asListOrEmpty();
        final SingletonElectionPolicy electionPolicy = (SingletonElectionPolicy)this.resolve(context, model);
        final LinkedList<Predicate<GroupMember>> preferences = new LinkedList<Predicate<GroupMember>>();
        CapabilityServiceInstaller.Builder builder = CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)new Supplier<SingletonElectionPolicy>(){

            @Override
            public SingletonElectionPolicy get() {
                return electionPolicy.prefer(Collections.unmodifiableList(preferences));
            }
        });
        if (!socketBindingPreferences.isEmpty()) {
            Resource policy = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false);
            String containerName = SingletonPolicyResourceDefinitionRegistrar.CACHE_ATTRIBUTE_GROUP.getContainerAttribute().resolveModelAttribute(context, policy.getModel()).asString();
            UnaryServiceDescriptor containerTransportChannel = UnaryServiceDescriptor.of((String)String.join((CharSequence)".", InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION.getName(), "transport", "jgroups"), Void.class);
            if (context.hasOptionalCapability(containerTransportChannel, containerName, CAPABILITY, SOCKET_BINDING_PREFERENCES)) {
                final ServiceDependency container = ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)containerName);
                builder.requires((Consumer)container);
                for (ModelNode socketBindingPreference : socketBindingPreferences) {
                    final ServiceDependency binding = ServiceDependency.on((UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR, (String)socketBindingPreference.asString());
                    builder.requires((Consumer)binding);
                    preferences.add(new Predicate<GroupMember>(){
                        private final JGroupsTransport transport;
                        private final Predicate<GroupMember> preference;
                        {
                            this.transport = (JGroupsTransport)((EmbeddedCacheManager)container.get()).getCacheManagerConfiguration().transport().jgroups().transport();
                            this.preference = new OutboundSocketBindingPreference((OutboundSocketBinding)binding.get(), this.transport.getChannel());
                        }

                        @Override
                        public boolean test(GroupMember member) {
                            return this.preference.test(member);
                        }

                        public String toString() {
                            return this.preference.toString();
                        }
                    });
                }
            }
        }
        if (!namePreferences.isEmpty()) {
            for (ModelNode namePreference : namePreferences) {
                final String name = namePreference.asString();
                preferences.add(new Predicate<GroupMember>(){

                    @Override
                    public boolean test(GroupMember member) {
                        return member.getName().equals(name);
                    }

                    public String toString() {
                        return name;
                    }
                });
            }
        }
        return (ResourceServiceInstaller)builder.build();
    }
}

