/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import java.io.FileInputStream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.commands.messages.ProducerThread;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import picocli.CommandLine;

@CommandLine.Command(name="producer", description={"Send message(s) to a broker."})
public class Producer
extends DestAbstract {
    public static final String DEMO_TEXT = "demo.txt";
    @CommandLine.Option(names={"--non-persistent"}, description={"Send messages non persistently."})
    boolean nonpersistent = false;
    @CommandLine.Option(names={"--message-size"}, description={"Size of each bytesMessage. The producer will use JMS BytesMessage."})
    int messageSize = 0;
    @CommandLine.Option(names={"--message"}, description={"Content of each textMessage. The producer will use JMS TextMessage."})
    String message = null;
    @CommandLine.Option(names={"--text-size"}, description={"Size of each textMessage. The producer will use JMS TextMessage."})
    int textMessageSize;
    @CommandLine.Option(names={"--object-size"}, description={"Size of each ObjectMessage. The producer will use JMS ObjectMessage."})
    int objectSize;
    @CommandLine.Option(names={"--msgttl"}, description={"TTL for each message."})
    long msgTTL = 0L;
    @CommandLine.Option(names={"--group"}, description={"Message Group to be used."})
    String msgGroupID = null;
    @CommandLine.Option(names={"--data"}, description={"Messages will be read from the specified file. Other message options will be ignored."})
    String file = null;
    @CommandLine.Option(names={"--properties"}, description={"The properties to set on the message in JSON, e.g.: [{\"type\":\"string\",\"key\":\"myKey1\",\"value\":\"myValue1\"},{\"type\":\"string\",\"key\":\"myKey2\",\"value\":\"myValue2\"}]. Valid types are boolean, byte, short, int, long, float, double, and string."})
    String properties = null;

    public boolean isNonpersistent() {
        return this.nonpersistent;
    }

    public Producer setNonpersistent(boolean nonpersistent) {
        this.nonpersistent = nonpersistent;
        return this;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public Producer setMessageSize(int messageSize) {
        this.messageSize = messageSize;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Producer setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getProperties() {
        return this.properties;
    }

    public Producer setProperties(String properties) {
        this.properties = properties;
        return this;
    }

    public int getTextMessageSize() {
        return this.textMessageSize;
    }

    public Producer setTextMessageSize(int textMessageSize) {
        this.textMessageSize = textMessageSize;
        return this;
    }

    public int getObjectSize() {
        return this.objectSize;
    }

    public Producer setObjectSize(int objectSize) {
        this.objectSize = objectSize;
        return this;
    }

    public long getMsgTTL() {
        return this.msgTTL;
    }

    public Producer setMsgTTL(long msgTTL) {
        this.msgTTL = msgTTL;
        return this;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public Producer setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public Producer setFile(String file) {
        this.file = file;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        ConnectionFactory factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            void var7_19;
            if (this.file != null) {
                void var7_16;
                FileInputStream in;
                MessageSerializer serializer;
                MessageProducer producer;
                Session session;
                block21: {
                    session = connection.createSession(true, 0);
                    Destination dest = this.getDestination(session);
                    producer = session.createProducer(dest);
                    producer.setDeliveryMode(2);
                    boolean bl = false;
                    serializer = this.getMessageSerializer();
                    if (serializer != null) break block21;
                    context.err.println("Error. Unable to instantiate serializer class: " + String.valueOf(serializer));
                    Object var9_26 = null;
                    return var9_26;
                }
                try {
                    in = new FileInputStream(this.file);
                }
                catch (Exception e) {
                    context.err.println("Error: Unable to open file for reading\n" + e.getMessage());
                    Object var11_32 = null;
                    if (connection != null) {
                        connection.close();
                    }
                    return var11_32;
                }
                try {
                    serializer.setInput(in, session);
                    serializer.start();
                    Message message = serializer.read();
                    while (message != null) {
                        producer.send(message);
                        message = serializer.read();
                        ++var7_16;
                    }
                    session.commit();
                    serializer.stop();
                }
                catch (Exception e) {
                    context.err.println("Error occurred during import.  Rolling back.");
                    session.rollback();
                    e.printStackTrace();
                    Integer n = 0;
                    return n;
                }
                context.out.println("Sent " + (int)var7_16 + " Messages.");
                Integer e = (int)var7_16;
                return e;
            }
            ProducerThread[] threadsArray = new ProducerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                Session session = this.txBatchSize > 0 ? connection.createSession(true, 0) : connection.createSession(false, 1);
                Destination destination = this.getDestination(session);
                threadsArray[i] = new ProducerThread(session, destination, i, context);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setPersistent(!this.nonpersistent).setMessageSize(this.messageSize).setTextMessageSize(this.textMessageSize).setMessage(this.message).setProperties(this.properties).setObjectSize(this.objectSize).setMsgTTL(this.msgTTL).setMsgGroupID(this.msgGroupID).setTransactionBatchSize(this.txBatchSize).setMessageCount(this.messageCount);
            }
            ProducerThread[] i = threadsArray;
            int n = i.length;
            boolean object = false;
            while (var7_19 < n) {
                ProducerThread thread = i[var7_19];
                thread.start();
                ++var7_19;
            }
            long messagesProduced = 0L;
            for (ProducerThread thread : threadsArray) {
                thread.join();
                messagesProduced += thread.getSentCount();
            }
            Long l = messagesProduced;
            return l;
        }
    }
}

