/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.concurrent.Callable;
import java.util.function.Function;

public interface Supplier<T>
extends java.util.function.Supplier<T> {
    public static final Supplier<?> NULL = new Supplier<Object>(){

        @Override
        public Object get() {
            return null;
        }
    };

    default public <V> Supplier<V> map(final Function<T, V> mapper) {
        return new Supplier<V>(){

            @Override
            public V get() {
                return mapper.apply(Supplier.this.get());
            }
        };
    }

    default public Supplier<T> handle(final Function<RuntimeException, T> handler) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return Supplier.this.get();
                }
                catch (RuntimeException e) {
                    return handler.apply(e);
                }
            }
        };
    }

    public static <T> Supplier<T> empty() {
        return NULL;
    }

    public static <T> Supplier<T> of(final T value) {
        return value != null ? new Supplier<T>(){

            @Override
            public T get() {
                return value;
            }
        } : Supplier.empty();
    }

    public static <T> Supplier<T> run(final Runnable task) {
        return task != null ? new Supplier<T>(){

            @Override
            public T get() {
                task.run();
                return null;
            }
        } : Supplier.empty();
    }

    public static <T> Supplier<T> call(final Callable<T> caller, final Function<Exception, T> handler) {
        return caller != null ? new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return caller.call();
                }
                catch (Exception e) {
                    return handler.apply(e);
                }
            }
        } : Supplier.empty();
    }
}

