/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import java.util.function.Function;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.ChannelConfiguration;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class RemoteSiteResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((BinaryServiceDescriptor)RemoteSiteConfiguration.SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_CHILD).build();
    static final CapabilityReferenceAttributeDefinition<ChannelConfiguration> CHANNEL_CONFIGURATION = new CapabilityReferenceAttributeDefinition.Builder("channel", CapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)ChannelConfiguration.SERVICE_DESCRIPTOR).build()).build();
    private final ResourceOperationRuntimeHandler parentRuntimeHandler;

    RemoteSiteResourceDefinitionRegistrar(ResourceOperationRuntimeHandler parentRuntimeHandler) {
        this.parentRuntimeHandler = parentRuntimeHandler;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(JGroupsResourceRegistration.REMOTE_SITE.getPathElement());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)resolver).addAttributes(List.of(CHANNEL_CONFIGURATION))).addCapability(CAPABILITY)).withRuntimeHandler(ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this), ResourceOperationRuntimeHandler.restartParent((ResourceOperationRuntimeHandler)this.parentRuntimeHandler)}))).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)JGroupsResourceRegistration.REMOTE_SITE, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        ServiceDependency site = CHANNEL_CONFIGURATION.resolve(context, model).map((Function)new Function<ChannelConfiguration, RemoteSiteConfiguration>(){

            @Override
            public RemoteSiteConfiguration apply(final ChannelConfiguration configuration) {
                return new RemoteSiteConfiguration(){

                    public String getName() {
                        return name;
                    }

                    public ChannelFactory getChannelFactory() {
                        return configuration.getChannelFactory();
                    }

                    public String getClusterName() {
                        return configuration.getClusterName();
                    }
                };
            }
        });
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (ServiceDependency)site).build();
    }
}

