/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.affinity;

import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.affinity.GroupMemberAffinityConfiguration;

public class UnaryGroupMemberAffinity<I>
implements Function<I, CacheContainerGroupMember> {
    private final Supplier<KeyDistribution> distribution;
    private final CacheContainerGroupMemberFactory factory;

    public UnaryGroupMemberAffinity(GroupMemberAffinityConfiguration<I> configuration) {
        this(configuration.getCache(), configuration.getGroup());
    }

    public UnaryGroupMemberAffinity(final Cache<? extends Key<I>, ?> cache, CacheContainerGroup group) {
        this(new Supplier<KeyDistribution>(){

            @Override
            public KeyDistribution get() {
                return KeyDistribution.forCache((Cache)cache);
            }
        }, group.getGroupMemberFactory());
    }

    UnaryGroupMemberAffinity(Supplier<KeyDistribution> distribution, CacheContainerGroupMemberFactory factory) {
        this.distribution = distribution;
        this.factory = factory;
    }

    @Override
    public CacheContainerGroupMember apply(I id) {
        CacheContainerGroupMember member = null;
        while (member == null) {
            Address address = this.distribution.get().getPrimaryOwner((Object)new CacheKey(id));
            if (address != null) {
                member = (CacheContainerGroupMember)this.factory.createGroupMember((Comparable)address);
                continue;
            }
            Thread.yield();
        }
        return member;
    }
}

